/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImageryReader {
    private String source;

    public ImageryReader(String source) {
        this.source = source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ImageryInfo> parse() throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            try (InputStream in = new CachedFile(this.source).setMaxAge(86400L).setCachingStrategy(CachedFile.CachingStrategy.IfModifiedSince).getInputStream();){
                InputSource is = new InputSource(UTFInputStreamReader.create(in));
                factory.newSAXParser().parse(is, (DefaultHandler)parser);
                List<ImageryInfo> list = parser.entries;
                return list;
            }
        }
        catch (SAXException e) {
            throw e;
        }
        catch (ParserConfigurationException e) {
            Main.error(e);
            throw new SAXException(e);
        }
    }

    private static class Parser
    extends DefaultHandler {
        private StringBuffer accumulator = new StringBuffer();
        private Stack<State> states;
        List<ImageryInfo> entries;
        boolean skipEntry;
        ImageryInfo entry;
        ImageryInfo.ImageryBounds bounds;
        Shape shape;
        String lang;
        List<String> projections;

        private Parser() {
        }

        @Override
        public void startDocument() {
            this.accumulator = new StringBuffer();
            this.skipEntry = false;
            this.states = new Stack();
            this.states.push(State.INIT);
            this.entries = new ArrayList<ImageryInfo>();
            this.entry = null;
            this.bounds = null;
            this.projections = null;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.accumulator.setLength(0);
            State newState = null;
            switch (this.states.peek()) {
                case INIT: {
                    if (!"imagery".equals(qName)) break;
                    newState = State.IMAGERY;
                    break;
                }
                case IMAGERY: {
                    if (!"entry".equals(qName)) break;
                    this.entry = new ImageryInfo();
                    this.skipEntry = false;
                    newState = State.ENTRY;
                    break;
                }
                case ENTRY: {
                    if (Arrays.asList("name", "id", "type", "description", "default", "url", "eula", "min-zoom", "max-zoom", "attribution-text", "attribution-url", "logo-image", "logo-url", "terms-of-use-text", "terms-of-use-url", "country-code", "icon").contains(qName)) {
                        newState = State.ENTRY_ATTRIBUTE;
                        this.lang = atts.getValue("lang");
                        break;
                    }
                    if ("bounds".equals(qName)) {
                        try {
                            this.bounds = new ImageryInfo.ImageryBounds(atts.getValue("min-lat") + "," + atts.getValue("min-lon") + "," + atts.getValue("max-lat") + "," + atts.getValue("max-lon"), ",");
                        }
                        catch (IllegalArgumentException e) {
                            break;
                        }
                        newState = State.BOUNDS;
                        break;
                    }
                    if (!"projections".equals(qName)) break;
                    this.projections = new ArrayList<String>();
                    newState = State.PROJECTIONS;
                    break;
                }
                case BOUNDS: {
                    if (!"shape".equals(qName)) break;
                    this.shape = new Shape();
                    newState = State.SHAPE;
                    break;
                }
                case SHAPE: {
                    if (!"point".equals(qName)) break;
                    try {
                        this.shape.addPoint(atts.getValue("lat"), atts.getValue("lon"));
                    }
                    catch (IllegalArgumentException e) {}
                    break;
                }
                case PROJECTIONS: {
                    if (!"code".equals(qName)) break;
                    newState = State.CODE;
                }
            }
            if (newState == null) {
                newState = State.UNKNOWN;
            }
            this.states.push(newState);
            if (newState == State.UNKNOWN && "true".equals(atts.getValue("mandatory"))) {
                this.skipEntry = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.accumulator.append(ch, start, length);
        }

        @Override
        public void endElement(String namespaceURI, String qName, String rqName) {
            switch (this.states.pop()) {
                case INIT: {
                    throw new RuntimeException("parsing error: more closing than opening elements");
                }
                case ENTRY: {
                    if (!"entry".equals(qName)) break;
                    if (!this.skipEntry) {
                        this.entries.add(this.entry);
                    }
                    this.entry = null;
                    break;
                }
                case ENTRY_ATTRIBUTE: {
                    block29 : switch (qName) {
                        case "name": {
                            this.entry.setName(this.lang == null ? LanguageInfo.getJOSMLocaleCode(null) : this.lang, this.accumulator.toString());
                            break;
                        }
                        case "description": {
                            this.entry.setDescription(this.lang, this.accumulator.toString());
                            break;
                        }
                        case "id": {
                            this.entry.setId(this.accumulator.toString());
                            break;
                        }
                        case "type": {
                            boolean found = false;
                            for (ImageryInfo.ImageryType type : ImageryInfo.ImageryType.values()) {
                                if (!Objects.equals(this.accumulator.toString(), type.getTypeString())) continue;
                                this.entry.setImageryType(type);
                                found = true;
                                break;
                            }
                            if (found) break;
                            this.skipEntry = true;
                            break;
                        }
                        case "default": {
                            switch (this.accumulator.toString()) {
                                case "true": {
                                    this.entry.setDefaultEntry(true);
                                    break block29;
                                }
                                case "false": {
                                    this.entry.setDefaultEntry(false);
                                    break block29;
                                }
                            }
                            this.skipEntry = true;
                            break;
                        }
                        case "url": {
                            this.entry.setUrl(this.accumulator.toString());
                            break;
                        }
                        case "eula": {
                            this.entry.setEulaAcceptanceRequired(this.accumulator.toString());
                            break;
                        }
                        case "min-zoom": 
                        case "max-zoom": {
                            Integer val = null;
                            try {
                                val = Integer.parseInt(this.accumulator.toString());
                            }
                            catch (NumberFormatException e) {
                                val = null;
                            }
                            if (val == null) {
                                this.skipEntry = true;
                                break;
                            }
                            if ("min-zoom".equals(qName)) {
                                this.entry.setDefaultMinZoom(val);
                                break;
                            }
                            this.entry.setDefaultMaxZoom(val);
                            break;
                        }
                        case "attribution-text": {
                            this.entry.setAttributionText(this.accumulator.toString());
                            break;
                        }
                        case "attribution-url": {
                            this.entry.setAttributionLinkURL(this.accumulator.toString());
                            break;
                        }
                        case "logo-image": {
                            this.entry.setAttributionImage(this.accumulator.toString());
                            break;
                        }
                        case "logo-url": {
                            this.entry.setAttributionImageURL(this.accumulator.toString());
                            break;
                        }
                        case "terms-of-use-text": {
                            this.entry.setTermsOfUseText(this.accumulator.toString());
                            break;
                        }
                        case "terms-of-use-url": {
                            this.entry.setTermsOfUseURL(this.accumulator.toString());
                            break;
                        }
                        case "country-code": {
                            this.entry.setCountryCode(this.accumulator.toString());
                            break;
                        }
                        case "icon": {
                            this.entry.setIcon(this.accumulator.toString());
                        }
                    }
                    break;
                }
                case BOUNDS: {
                    this.entry.setBounds(this.bounds);
                    this.bounds = null;
                    break;
                }
                case SHAPE: {
                    this.bounds.addShape(this.shape);
                    this.shape = null;
                    break;
                }
                case CODE: {
                    this.projections.add(this.accumulator.toString());
                    break;
                }
                case PROJECTIONS: {
                    this.entry.setServerProjections(this.projections);
                    this.projections = null;
                }
            }
        }
    }

    private static enum State {
        INIT,
        IMAGERY,
        ENTRY,
        ENTRY_ATTRIBUTE,
        PROJECTIONS,
        CODE,
        BOUNDS,
        SHAPE,
        UNKNOWN;

    }
}

