/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.awt.Component;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Objects;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.AbstractCredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.tools.I18n;

public class JosmPreferencesCredentialAgent
extends AbstractCredentialsAgent {
    @Override
    public PasswordAuthentication lookup(Authenticator.RequestorType requestorType, String host) throws CredentialsAgentException {
        if (requestorType == null) {
            return null;
        }
        switch (requestorType) {
            case SERVER: {
                String password;
                String user;
                if (Objects.equals(OsmApi.getOsmApi().getHost(), host)) {
                    user = Main.pref.get("osm-server.username", null);
                    password = Main.pref.get("osm-server.password", null);
                } else if (host != null) {
                    user = Main.pref.get("server.username." + host, null);
                    password = Main.pref.get("server.password." + host, null);
                } else {
                    user = null;
                    password = null;
                }
                if (user == null) {
                    return null;
                }
                return new PasswordAuthentication(user, password == null ? new char[]{} : password.toCharArray());
            }
            case PROXY: {
                String user = Main.pref.get("proxy.user", null);
                String password = Main.pref.get("proxy.pass", null);
                if (user == null) {
                    return null;
                }
                return new PasswordAuthentication(user, password == null ? new char[]{} : password.toCharArray());
            }
        }
        return null;
    }

    @Override
    public void store(Authenticator.RequestorType requestorType, String host, PasswordAuthentication credentials) throws CredentialsAgentException {
        if (requestorType == null) {
            return;
        }
        switch (requestorType) {
            case SERVER: {
                if (Objects.equals(OsmApi.getOsmApi().getHost(), host)) {
                    Main.pref.put("osm-server.username", credentials.getUserName());
                    if (credentials.getPassword() == null) {
                        Main.pref.put("osm-server.password", null);
                        break;
                    }
                    Main.pref.put("osm-server.password", String.valueOf(credentials.getPassword()));
                    break;
                }
                if (host == null) break;
                Main.pref.put("server.username." + host, credentials.getUserName());
                if (credentials.getPassword() == null) {
                    Main.pref.put("server.password." + host, null);
                    break;
                }
                Main.pref.put("server.password." + host, String.valueOf(credentials.getPassword()));
                break;
            }
            case PROXY: {
                Main.pref.put("proxy.user", credentials.getUserName());
                if (credentials.getPassword() == null) {
                    Main.pref.put("proxy.pass", null);
                    break;
                }
                Main.pref.put("proxy.pass", String.valueOf(credentials.getPassword()));
            }
        }
    }

    @Override
    public OAuthToken lookupOAuthAccessToken() throws CredentialsAgentException {
        String accessTokenKey = Main.pref.get("oauth.access-token.key", null);
        String accessTokenSecret = Main.pref.get("oauth.access-token.secret", null);
        if (accessTokenKey == null && accessTokenSecret == null) {
            return null;
        }
        return new OAuthToken(accessTokenKey, accessTokenSecret);
    }

    @Override
    public void storeOAuthAccessToken(OAuthToken accessToken) throws CredentialsAgentException {
        if (accessToken == null) {
            Main.pref.put("oauth.access-token.key", null);
            Main.pref.put("oauth.access-token.secret", null);
        } else {
            Main.pref.put("oauth.access-token.key", accessToken.getKey());
            Main.pref.put("oauth.access-token.secret", accessToken.getSecret());
        }
    }

    @Override
    public Component getPreferencesDecorationPanel() {
        HtmlPanel pnlMessage = new HtmlPanel();
        HTMLEditorKit kit = (HTMLEditorKit)pnlMessage.getEditorPane().getEditorKit();
        kit.getStyleSheet().addRule(".warning-body {background-color:rgb(253,255,221);padding: 10pt; border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
        pnlMessage.setText(I18n.tr("<html><body><p class=\"warning-body\"><strong>Warning:</strong> The password is stored in plain text in the JOSM preferences file. Furthermore, it is transferred <strong>unencrypted</strong> in every request sent to the OSM server. <strong>Do not use a valuable password.</strong></p></body></html>", new Object[0]));
        return pnlMessage;
    }

    @Override
    public String getSaveUsernameAndPasswordCheckboxText() {
        return I18n.tr("Save user and password (unencrypted)", new Object[0]);
    }
}

