/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.awt.Component;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Objects;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.JosmPreferencesCredentialAgent;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class CredentialsManager
implements CredentialsAgent {
    private static volatile CredentialsManager instance;
    private static CredentialsAgentFactory agentFactory;
    private CredentialsAgent delegate;

    public static CredentialsManager getInstance() {
        if (instance == null) {
            CredentialsAgent delegate = agentFactory == null ? new JosmPreferencesCredentialAgent() : agentFactory.getCredentialsAgent();
            instance = new CredentialsManager(delegate);
        }
        return instance;
    }

    public static void registerCredentialsAgentFactory(CredentialsAgentFactory agentFactory) {
        CredentialsManager.agentFactory = agentFactory;
        instance = null;
    }

    public CredentialsManager(CredentialsAgent delegate) {
        CheckParameterUtil.ensureParameterNotNull(delegate, "delegate");
        this.delegate = delegate;
    }

    public final Class<? extends CredentialsAgent> getCredentialsAgentClass() {
        return this.delegate.getClass();
    }

    public String getUsername() {
        return this.getUsername(OsmApi.getOsmApi().getHost());
    }

    public String getUsername(String host) {
        String username = null;
        try {
            PasswordAuthentication auth = this.lookup(Authenticator.RequestorType.SERVER, host);
            if (auth != null) {
                username = auth.getUserName();
            }
        }
        catch (CredentialsAgentException ex) {
            return null;
        }
        if (username == null) {
            return null;
        }
        return (username = username.trim()).isEmpty() ? null : username;
    }

    @Override
    public PasswordAuthentication lookup(Authenticator.RequestorType requestorType, String host) throws CredentialsAgentException {
        return this.delegate.lookup(requestorType, host);
    }

    @Override
    public void store(Authenticator.RequestorType requestorType, String host, PasswordAuthentication credentials) throws CredentialsAgentException {
        String username;
        if (requestorType == Authenticator.RequestorType.SERVER && Objects.equals(OsmApi.getOsmApi().getHost(), host) && (username = credentials.getUserName()) != null && !username.trim().isEmpty()) {
            JosmUserIdentityManager.getInstance().setPartiallyIdentified(username);
        }
        this.delegate.store(requestorType, host, credentials);
    }

    @Override
    public CredentialsAgentResponse getCredentials(Authenticator.RequestorType requestorType, String host, boolean noSuccessWithLastResponse) throws CredentialsAgentException {
        return this.delegate.getCredentials(requestorType, host, noSuccessWithLastResponse);
    }

    @Override
    public OAuthToken lookupOAuthAccessToken() throws CredentialsAgentException {
        return this.delegate.lookupOAuthAccessToken();
    }

    @Override
    public void storeOAuthAccessToken(OAuthToken accessToken) throws CredentialsAgentException {
        this.delegate.storeOAuthAccessToken(accessToken);
    }

    @Override
    public Component getPreferencesDecorationPanel() {
        return this.delegate.getPreferencesDecorationPanel();
    }

    public static interface CredentialsAgentFactory {
        public CredentialsAgent getCredentialsAgent();
    }
}

