/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.awt.GraphicsEnvironment;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.gui.io.CredentialDialog;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.auth.CredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;

public abstract class AbstractCredentialsAgent
implements CredentialsAgent {
    protected Map<Authenticator.RequestorType, PasswordAuthentication> memoryCredentialsCache = new HashMap<Authenticator.RequestorType, PasswordAuthentication>();

    @Override
    public CredentialsAgentResponse getCredentials(final Authenticator.RequestorType requestorType, final String host, boolean noSuccessWithLastResponse) throws CredentialsAgentException {
        if (requestorType == null) {
            return null;
        }
        PasswordAuthentication credentials = this.lookup(requestorType, host);
        final String username = credentials == null || credentials.getUserName() == null ? "" : credentials.getUserName();
        final String password = credentials == null || credentials.getPassword() == null ? "" : String.valueOf(credentials.getPassword());
        final CredentialsAgentResponse response = new CredentialsAgentResponse();
        if (!noSuccessWithLastResponse && this.memoryCredentialsCache.containsKey((Object)requestorType) && (credentials == null || credentials.getPassword() == null || credentials.getPassword().length == 0)) {
            PasswordAuthentication pa = this.memoryCredentialsCache.get((Object)requestorType);
            response.setUsername(pa.getUserName());
            response.setPassword(pa.getPassword());
            response.setCanceled(false);
        } else if (noSuccessWithLastResponse || username.isEmpty() || password.isEmpty()) {
            if (!GraphicsEnvironment.isHeadless()) {
                GuiHelper.runInEDTAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CredentialDialog dialog = null;
                        dialog = requestorType.equals((Object)Authenticator.RequestorType.PROXY) ? CredentialDialog.getHttpProxyCredentialDialog(username, password, host, AbstractCredentialsAgent.this.getSaveUsernameAndPasswordCheckboxText()) : CredentialDialog.getOsmApiCredentialDialog(username, password, host, AbstractCredentialsAgent.this.getSaveUsernameAndPasswordCheckboxText());
                        dialog.setVisible(true);
                        response.setCanceled(dialog.isCanceled());
                        if (dialog.isCanceled()) {
                            return;
                        }
                        response.setUsername(dialog.getUsername());
                        response.setPassword(dialog.getPassword());
                        response.setSaveCredentials(dialog.isSaveCredentials());
                    }
                });
            }
            if (response.isCanceled() || response.getUsername() == null || response.getPassword() == null) {
                return response;
            }
            if (response.isSaveCredentials()) {
                this.store(requestorType, host, new PasswordAuthentication(response.getUsername(), response.getPassword()));
            } else {
                PasswordAuthentication pa = new PasswordAuthentication(response.getUsername(), response.getPassword());
                this.memoryCredentialsCache.put(requestorType, pa);
            }
        } else {
            response.setUsername(username);
            response.setPassword(password.toCharArray());
            response.setCanceled(false);
        }
        return response;
    }

    public abstract String getSaveUsernameAndPasswordCheckboxText();
}

