/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class XmlWriter
implements Closeable {
    protected final PrintWriter out;
    private static final Map<Character, String> encoding = new HashMap<Character, String>();

    public XmlWriter(PrintWriter out) {
        this.out = out;
    }

    public void flush() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public static String encode(String unencoded) {
        return XmlWriter.encode(unencoded, false);
    }

    public static String encode(String unencoded, boolean keepApos) {
        StringBuilder buffer = null;
        for (int i = 0; i < unencoded.length(); ++i) {
            String encS = null;
            if (!keepApos || unencoded.charAt(i) != '\'') {
                encS = encoding.get(Character.valueOf(unencoded.charAt(i)));
            }
            if (encS != null) {
                if (buffer == null) {
                    buffer = new StringBuilder(unencoded.substring(0, i));
                }
                buffer.append(encS);
                continue;
            }
            if (buffer == null) continue;
            buffer.append(unencoded.charAt(i));
        }
        return buffer == null ? unencoded : buffer.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    static {
        encoding.put(Character.valueOf('<'), "&lt;");
        encoding.put(Character.valueOf('>'), "&gt;");
        encoding.put(Character.valueOf('\"'), "&quot;");
        encoding.put(Character.valueOf('\''), "&apos;");
        encoding.put(Character.valueOf('&'), "&amp;");
        encoding.put(Character.valueOf('\n'), "&#xA;");
        encoding.put(Character.valueOf('\r'), "&#xD;");
        encoding.put(Character.valueOf('\t'), "&#x9;");
    }
}

