/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class ProgressInputStream
extends InputStream {
    private final InputStream in;
    private int readSoFar = 0;
    private int lastDialogUpdate = 0;
    private boolean sizeKnown;
    private final URLConnection connection;
    private final ProgressMonitor progressMonitor;

    public ProgressInputStream(URLConnection con, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.connection = con;
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.progressMonitor = progressMonitor;
        progressMonitor.beginTask(I18n.tr("Contacting OSM Server...", new Object[0]), 1);
        progressMonitor.indeterminateSubTask(null);
        try {
            this.in = con.getInputStream();
        }
        catch (IOException e) {
            progressMonitor.finishTask();
            if (con.getHeaderField("Error") != null) {
                throw new OsmTransferException(I18n.tr(con.getHeaderField("Error"), new Object[0]));
            }
            throw new OsmTransferException(e);
        }
        this.updateSize();
        if (!this.sizeKnown) {
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading OSM data...", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            this.progressMonitor.finishTask();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read != -1) {
            this.advanceTicker(read);
        } else {
            this.progressMonitor.finishTask();
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        int read = this.in.read();
        if (read != -1) {
            this.advanceTicker(1);
        } else {
            this.progressMonitor.finishTask();
        }
        return read;
    }

    private void advanceTicker(int amount) {
        this.readSoFar += amount;
        this.updateSize();
        if (this.readSoFar / 1024 != this.lastDialogUpdate) {
            ++this.lastDialogUpdate;
            if (this.sizeKnown) {
                this.progressMonitor.setTicks(this.readSoFar);
            }
            this.progressMonitor.setExtraText(this.readSoFar / 1024 + " KB");
        }
    }

    private void updateSize() {
        if (!this.sizeKnown && this.connection.getContentLength() > 0) {
            this.sizeKnown = true;
            this.progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
            this.progressMonitor.setTicksCount(this.connection.getContentLength());
        }
    }
}

