/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;

public class OsmWriter
extends XmlWriter
implements PrimitiveVisitor {
    public static final String DEFAULT_API_VERSION = "0.6";
    private boolean osmConform;
    private boolean withBody = true;
    private boolean isOsmChange;
    private String version;
    private Changeset changeset;
    protected static final Comparator<OsmPrimitive> byIdComparator = new Comparator<OsmPrimitive>(){

        @Override
        public int compare(OsmPrimitive o1, OsmPrimitive o2) {
            return o1.getUniqueId() < o2.getUniqueId() ? -1 : (o1.getUniqueId() == o2.getUniqueId() ? 0 : 1);
        }
    };
    protected static final Comparator<Map.Entry<String, String>> byKeyComparator = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    protected OsmWriter(PrintWriter out, boolean osmConform, String version) {
        super(out);
        this.osmConform = osmConform;
        this.version = version == null ? DEFAULT_API_VERSION : version;
    }

    public void setWithBody(boolean wb) {
        this.withBody = wb;
    }

    public void setIsOsmChange(boolean isOsmChange) {
        this.isOsmChange = isOsmChange;
    }

    public void setChangeset(Changeset cs) {
        this.changeset = cs;
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public void header() {
        this.header(null);
    }

    public void header(Boolean upload) {
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.print("<osm version='");
        this.out.print(this.version);
        if (upload != null) {
            this.out.print("' upload='");
            this.out.print(upload);
        }
        this.out.println("' generator='JOSM'>");
    }

    public void footer() {
        this.out.println("</osm>");
    }

    protected <T extends OsmPrimitive> Collection<T> sortById(Collection<T> primitives) {
        ArrayList<T> result = new ArrayList<T>(primitives.size());
        result.addAll(primitives);
        Collections.sort(result, byIdComparator);
        return result;
    }

    public void writeLayer(OsmDataLayer layer) {
        this.header(!layer.isUploadDiscouraged());
        this.writeDataSources(layer.data);
        this.writeContent(layer.data);
        this.footer();
    }

    public void writeContent(DataSet ds) {
        this.writeNodes(ds.getNodes());
        this.writeWays(ds.getWays());
        this.writeRelations(ds.getRelations());
    }

    public void writeNodes(Collection<Node> nodes) {
        for (Node n : this.sortById(nodes)) {
            if (!this.shouldWrite(n)) continue;
            this.visit(n);
        }
    }

    public void writeWays(Collection<Way> ways) {
        for (Way w : this.sortById(ways)) {
            if (!this.shouldWrite(w)) continue;
            this.visit(w);
        }
    }

    public void writeRelations(Collection<Relation> relations) {
        for (Relation r : this.sortById(relations)) {
            if (!this.shouldWrite(r)) continue;
            this.visit(r);
        }
    }

    protected boolean shouldWrite(OsmPrimitive osm) {
        return !osm.isNewOrUndeleted() || !osm.isDeleted();
    }

    public void writeDataSources(DataSet ds) {
        for (DataSource s : ds.dataSources) {
            this.out.println("  <bounds minlat='" + s.bounds.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + "' minlon='" + s.bounds.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "' maxlat='" + s.bounds.getMax().latToString(CoordinateFormat.DECIMAL_DEGREES) + "' maxlon='" + s.bounds.getMax().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "' origin='" + XmlWriter.encode(s.origin) + "' />");
        }
    }

    @Override
    public void visit(INode n) {
        if (n.isIncomplete()) {
            return;
        }
        this.addCommon(n, "node");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            if (n.getCoor() != null) {
                this.out.print(" lat='" + LatLon.cDdHighPecisionFormatter.format(n.getCoor().lat()) + "' lon='" + LatLon.cDdHighPecisionFormatter.format(n.getCoor().lon()) + "'");
            }
            this.addTags(n, "node", true);
        }
    }

    @Override
    public void visit(IWay w) {
        if (w.isIncomplete()) {
            return;
        }
        this.addCommon(w, "way");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (int i = 0; i < w.getNodesCount(); ++i) {
                this.out.println("    <nd ref='" + w.getNodeId(i) + "' />");
            }
            this.addTags(w, "way", false);
        }
    }

    @Override
    public void visit(IRelation e) {
        if (e.isIncomplete()) {
            return;
        }
        this.addCommon(e, "relation");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (int i = 0; i < e.getMembersCount(); ++i) {
                this.out.print("    <member type='");
                this.out.print(e.getMemberType(i).getAPIName());
                this.out.println("' ref='" + e.getMemberId(i) + "' role='" + XmlWriter.encode(e.getRole(i)) + "' />");
            }
            this.addTags(e, "relation", false);
        }
    }

    public void visit(Changeset cs) {
        this.out.print("  <changeset ");
        this.out.print(" id='" + cs.getId() + "'");
        if (cs.getUser() != null) {
            this.out.print(" user='" + cs.getUser().getName() + "'");
            this.out.print(" uid='" + cs.getUser().getId() + "'");
        }
        if (cs.getCreatedAt() != null) {
            this.out.print(" created_at='" + DateUtils.fromDate(cs.getCreatedAt()) + "'");
        }
        if (cs.getClosedAt() != null) {
            this.out.print(" closed_at='" + DateUtils.fromDate(cs.getClosedAt()) + "'");
        }
        this.out.print(" open='" + (cs.isOpen() ? "true" : "false") + "'");
        if (cs.getMin() != null) {
            this.out.print(" min_lon='" + cs.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
            this.out.print(" min_lat='" + cs.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
        }
        if (cs.getMax() != null) {
            this.out.print(" max_lon='" + cs.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
            this.out.print(" max_lat='" + cs.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
        }
        this.out.println(">");
        this.addTags(cs, "changeset", false);
    }

    protected void addTags(Tagged osm, String tagname, boolean tagOpen) {
        if (osm.hasKeys()) {
            if (tagOpen) {
                this.out.println(">");
            }
            ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(osm.getKeys().entrySet());
            Collections.sort(entries, byKeyComparator);
            for (Map.Entry entry : entries) {
                this.out.println("    <tag k='" + XmlWriter.encode((String)entry.getKey()) + "' v='" + XmlWriter.encode((String)entry.getValue()) + "' />");
            }
            this.out.println("  </" + tagname + ">");
        } else if (tagOpen) {
            this.out.println(" />");
        } else {
            this.out.println("  </" + tagname + ">");
        }
    }

    protected void addCommon(IPrimitive osm, String tagname) {
        this.out.print("  <" + tagname);
        if (osm.getUniqueId() == 0L) {
            throw new IllegalStateException(I18n.tr("Unexpected id 0 for osm primitive found", new Object[0]));
        }
        this.out.print(" id='" + osm.getUniqueId() + "'");
        if (!this.isOsmChange) {
            if (!this.osmConform) {
                String action = null;
                if (osm.isDeleted()) {
                    action = "delete";
                } else if (osm.isModified()) {
                    action = "modify";
                }
                if (action != null) {
                    this.out.print(" action='" + action + "'");
                }
            }
            if (!osm.isTimestampEmpty()) {
                this.out.print(" timestamp='" + DateUtils.fromDate(osm.getTimestamp()) + "'");
            }
            if (osm.getUser() != null) {
                if (osm.getUser().isLocalUser()) {
                    this.out.print(" user='" + XmlWriter.encode(osm.getUser().getName()) + "'");
                } else if (osm.getUser().isOsmUser()) {
                    this.out.print(" uid='" + osm.getUser().getId() + "'");
                    this.out.print(" user='" + XmlWriter.encode(osm.getUser().getName()) + "'");
                }
            }
            this.out.print(" visible='" + osm.isVisible() + "'");
        }
        if (osm.getVersion() != 0) {
            this.out.print(" version='" + osm.getVersion() + "'");
        }
        if (this.changeset != null && this.changeset.getId() != 0) {
            this.out.print(" changeset='" + this.changeset.getId() + "'");
        } else if (osm.getChangesetId() > 0 && !osm.isNew()) {
            this.out.print(" changeset='" + osm.getChangesetId() + "'");
        }
    }
}

