/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.LinkedList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OsmServerUserInfoReader
extends OsmServerReader {
    protected static String getAttribute(Node node, String name) {
        return node.getAttributes().getNamedItem(name).getNodeValue();
    }

    public static UserInfo buildFromXML(Document document) throws XmlParsingException {
        try {
            NodeList xmlNodeList;
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            UserInfo userInfo = new UserInfo();
            Node xmlNode = (Node)xpath.compile("/osm/user[1]").evaluate(document, XPathConstants.NODE);
            if (xmlNode == null) {
                throw new XmlParsingException(I18n.tr("XML tag <user> is missing.", new Object[0]));
            }
            String v = OsmServerUserInfoReader.getAttribute(xmlNode, "id");
            if (v == null) {
                throw new XmlParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "id", "user"));
            }
            try {
                userInfo.setId(Integer.parseInt(v));
            }
            catch (NumberFormatException e) {
                throw new XmlParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "id", "user", v));
            }
            v = OsmServerUserInfoReader.getAttribute(xmlNode, "display_name");
            userInfo.setDisplayName(v);
            v = OsmServerUserInfoReader.getAttribute(xmlNode, "account_created");
            if (v != null) {
                userInfo.setAccountCreated(DateUtils.fromString(v));
            }
            if ((xmlNode = (Node)xpath.compile("/osm/user[1]/description[1]/text()").evaluate(document, XPathConstants.NODE)) != null) {
                userInfo.setDescription(xmlNode.getNodeValue());
            }
            if ((xmlNode = (Node)xpath.compile("/osm/user[1]/home").evaluate(document, XPathConstants.NODE)) != null) {
                int zoom;
                double lon;
                double lat;
                v = OsmServerUserInfoReader.getAttribute(xmlNode, "lat");
                if (v == null) {
                    throw new XmlParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "lat", "home"));
                }
                try {
                    lat = Double.parseDouble(v);
                }
                catch (NumberFormatException e) {
                    throw new XmlParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "lat", "home", v));
                }
                v = OsmServerUserInfoReader.getAttribute(xmlNode, "lon");
                if (v == null) {
                    throw new XmlParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "lon", "home"));
                }
                try {
                    lon = Double.parseDouble(v);
                }
                catch (NumberFormatException e) {
                    throw new XmlParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "lon", "home", v));
                }
                v = OsmServerUserInfoReader.getAttribute(xmlNode, "zoom");
                if (v == null) {
                    throw new XmlParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "zoom", "home"));
                }
                try {
                    zoom = Integer.parseInt(v);
                }
                catch (NumberFormatException e) {
                    throw new XmlParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "zoom", "home", v));
                }
                userInfo.setHome(new LatLon(lat, lon));
                userInfo.setHomeZoom(zoom);
            }
            if ((xmlNodeList = (NodeList)xpath.compile("/osm/user[1]/languages[1]/lang/text()").evaluate(document, XPathConstants.NODESET)) != null) {
                LinkedList<String> languages = new LinkedList<String>();
                for (int i = 0; i < xmlNodeList.getLength(); ++i) {
                    languages.add(xmlNodeList.item(i).getNodeValue());
                }
                userInfo.setLanguages(languages);
            }
            if ((xmlNode = (Node)xpath.compile("/osm/user[1]/messages/received").evaluate(document, XPathConstants.NODE)) != null) {
                v = OsmServerUserInfoReader.getAttribute(xmlNode, "unread");
                if (v == null) {
                    throw new XmlParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "unread", "received"));
                }
                try {
                    userInfo.setUnreadMessages(Integer.parseInt(v));
                }
                catch (NumberFormatException e) {
                    throw new XmlParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "unread", "received", v), e);
                }
            }
            return userInfo;
        }
        catch (XPathException e) {
            throw new XmlParsingException(e);
        }
    }

    public OsmServerUserInfoReader() {
        this.setDoAuthenticate(true);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public UserInfo fetchUserInfo(ProgressMonitor monitor) throws OsmTransferException {
        return this.fetchUserInfo(monitor, null);
    }

    /*
     * Exception decompiling
     */
    public UserInfo fetchUserInfo(ProgressMonitor monitor, String reason) throws OsmTransferException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

