/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.ImportCancelException;
import org.openstreetmap.josm.io.OsmServerReadPostprocessor;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;

public class OsmReader
extends AbstractReader {
    protected XMLStreamReader parser;
    protected boolean cancel;
    private static volatile List<OsmServerReadPostprocessor> postprocessors;

    public static void registerPostprocessor(OsmServerReadPostprocessor pp) {
        if (postprocessors == null) {
            postprocessors = new ArrayList<OsmServerReadPostprocessor>();
        }
        postprocessors.add(pp);
    }

    public static void deregisterPostprocessor(OsmServerReadPostprocessor pp) {
        if (postprocessors != null) {
            postprocessors.remove(pp);
        }
    }

    protected OsmReader() {
    }

    protected void setParser(XMLStreamReader parser) {
        this.parser = parser;
    }

    protected void throwException(String msg, Throwable th) throws XMLStreamException {
        throw new OsmParsingException(msg, this.parser.getLocation(), th);
    }

    protected void throwException(String msg) throws XMLStreamException {
        throw new OsmParsingException(msg, this.parser.getLocation());
    }

    protected void parse() throws XMLStreamException {
        int event = this.parser.getEventType();
        while (true) {
            if (event == 1) {
                this.parseRoot();
            } else if (event == 2) {
                return;
            }
            if (!this.parser.hasNext()) break;
            event = this.parser.next();
        }
        this.parser.close();
    }

    protected void parseRoot() throws XMLStreamException {
        if ("osm".equals(this.parser.getLocalName())) {
            this.parseOsm();
        } else {
            this.parseUnknown();
        }
    }

    private void parseOsm() throws XMLStreamException {
        String v = this.parser.getAttributeValue(null, "version");
        if (v == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
        }
        if (!"0.6".equals(v)) {
            this.throwException(I18n.tr("Unsupported version: {0}", v));
        }
        this.ds.setVersion(v);
        String upload = this.parser.getAttributeValue(null, "upload");
        if (upload != null) {
            this.ds.setUploadDiscouraged(!Boolean.parseBoolean(upload));
        }
        String generator = this.parser.getAttributeValue(null, "generator");
        Long uploadChangesetId = null;
        if (this.parser.getAttributeValue(null, "upload-changeset") != null) {
            uploadChangesetId = this.getLong("upload-changeset");
        }
        while (true) {
            int event = this.parser.next();
            if (this.cancel) {
                this.cancel = false;
                throw new OsmParsingCanceledException(I18n.tr("Reading was canceled", new Object[0]), this.parser.getLocation());
            }
            if (event == 1) {
                switch (this.parser.getLocalName()) {
                    case "bounds": {
                        this.parseBounds(generator);
                        break;
                    }
                    case "node": {
                        this.parseNode();
                        break;
                    }
                    case "way": {
                        this.parseWay();
                        break;
                    }
                    case "relation": {
                        this.parseRelation();
                        break;
                    }
                    case "changeset": {
                        this.parseChangeset(uploadChangesetId);
                        break;
                    }
                    default: {
                        this.parseUnknown();
                        break;
                    }
                }
                continue;
            }
            if (event == 2) break;
        }
    }

    private void parseBounds(String generator) throws XMLStreamException {
        String minlon = this.parser.getAttributeValue(null, "minlon");
        String minlat = this.parser.getAttributeValue(null, "minlat");
        String maxlon = this.parser.getAttributeValue(null, "maxlon");
        String maxlat = this.parser.getAttributeValue(null, "maxlat");
        String origin = this.parser.getAttributeValue(null, "origin");
        if (minlon != null && maxlon != null && minlat != null && maxlat != null) {
            Bounds bounds;
            if (origin == null) {
                origin = generator;
            }
            if ((bounds = new Bounds(Double.parseDouble(minlat), Double.parseDouble(minlon), Double.parseDouble(maxlat), Double.parseDouble(maxlon))).isOutOfTheWorld()) {
                Bounds copy = new Bounds(bounds);
                bounds.normalize();
                Main.info("Bbox " + copy + " is out of the world, normalized to " + bounds);
            }
            DataSource src = new DataSource(bounds, origin);
            this.ds.dataSources.add(src);
        } else {
            this.throwException(I18n.tr("Missing mandatory attributes on element ''bounds''. Got minlon=''{0}'',minlat=''{1}'',maxlon=''{3}'',maxlat=''{4}'', origin=''{5}''.", minlon, minlat, maxlon, maxlat, origin));
        }
        this.jumpToEnd();
    }

    protected Node parseNode() throws XMLStreamException {
        NodeData nd = new NodeData();
        String lat = this.parser.getAttributeValue(null, "lat");
        String lon = this.parser.getAttributeValue(null, "lon");
        if (lat != null && lon != null) {
            nd.setCoor(new LatLon(Double.parseDouble(lat), Double.parseDouble(lon)));
        }
        this.readCommon(nd);
        Node n = new Node(nd.getId(), nd.getVersion());
        n.setVisible(nd.isVisible());
        n.load(nd);
        this.externalIdMap.put(nd.getPrimitiveId(), n);
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                if ("tag".equals(this.parser.getLocalName())) {
                    this.parseTag(n);
                    continue;
                }
                this.parseUnknown();
                continue;
            }
            if (event == 2) break;
        }
        return n;
    }

    protected Way parseWay() throws XMLStreamException {
        WayData wd = new WayData();
        this.readCommon(wd);
        Way w = new Way(wd.getId(), wd.getVersion());
        w.setVisible(wd.isVisible());
        w.load(wd);
        this.externalIdMap.put(wd.getPrimitiveId(), w);
        ArrayList<Long> nodeIds = new ArrayList<Long>();
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                switch (this.parser.getLocalName()) {
                    case "nd": {
                        nodeIds.add(this.parseWayNode(w));
                        break;
                    }
                    case "tag": {
                        this.parseTag(w);
                        break;
                    }
                    default: {
                        this.parseUnknown();
                        break;
                    }
                }
                continue;
            }
            if (event == 2) break;
        }
        if (w.isDeleted() && !nodeIds.isEmpty()) {
            Main.info(I18n.tr("Deleted way {0} contains nodes", w.getUniqueId()));
            nodeIds = new ArrayList();
        }
        this.ways.put(wd.getUniqueId(), nodeIds);
        return w;
    }

    private long parseWayNode(Way w) throws XMLStreamException {
        long id;
        if (this.parser.getAttributeValue(null, "ref") == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' on <nd> of way {1}.", "ref", w.getUniqueId()));
        }
        if ((id = this.getLong("ref")) == 0L) {
            this.throwException(I18n.tr("Illegal value of attribute ''ref'' of element <nd>. Got {0}.", id));
        }
        this.jumpToEnd();
        return id;
    }

    protected Relation parseRelation() throws XMLStreamException {
        RelationData rd = new RelationData();
        this.readCommon(rd);
        Relation r = new Relation(rd.getId(), rd.getVersion());
        r.setVisible(rd.isVisible());
        r.load(rd);
        this.externalIdMap.put(rd.getPrimitiveId(), r);
        ArrayList<RelationMemberData> members = new ArrayList<RelationMemberData>();
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                switch (this.parser.getLocalName()) {
                    case "member": {
                        members.add(this.parseRelationMember(r));
                        break;
                    }
                    case "tag": {
                        this.parseTag(r);
                        break;
                    }
                    default: {
                        this.parseUnknown();
                        break;
                    }
                }
                continue;
            }
            if (event == 2) break;
        }
        if (r.isDeleted() && !members.isEmpty()) {
            Main.info(I18n.tr("Deleted relation {0} contains members", r.getUniqueId()));
            members = new ArrayList();
        }
        this.relations.put(rd.getUniqueId(), members);
        return r;
    }

    private RelationMemberData parseRelationMember(Relation r) throws XMLStreamException {
        String role = null;
        OsmPrimitiveType type = null;
        long id = 0L;
        String value = this.parser.getAttributeValue(null, "ref");
        if (value == null) {
            this.throwException(I18n.tr("Missing attribute ''ref'' on member in relation {0}.", r.getUniqueId()));
        }
        try {
            id = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            this.throwException(I18n.tr("Illegal value for attribute ''ref'' on member in relation {0}. Got {1}", Long.toString(r.getUniqueId()), value), e);
        }
        value = this.parser.getAttributeValue(null, "type");
        if (value == null) {
            this.throwException(I18n.tr("Missing attribute ''type'' on member {0} in relation {1}.", Long.toString(id), Long.toString(r.getUniqueId())));
        }
        try {
            type = OsmPrimitiveType.fromApiTypeName(value);
        }
        catch (IllegalArgumentException e) {
            this.throwException(I18n.tr("Illegal value for attribute ''type'' on member {0} in relation {1}. Got {2}.", Long.toString(id), Long.toString(r.getUniqueId()), value), e);
        }
        role = value = this.parser.getAttributeValue(null, "role");
        if (id == 0L) {
            this.throwException(I18n.tr("Incomplete <member> specification with ref=0", new Object[0]));
        }
        this.jumpToEnd();
        return new RelationMemberData(role, type, id);
    }

    private void parseChangeset(Long uploadChangesetId) throws XMLStreamException {
        Long id = null;
        if (this.parser.getAttributeValue(null, "id") != null) {
            id = this.getLong("id");
        }
        if (id == uploadChangesetId || id != null && id.equals(uploadChangesetId)) {
            this.uploadChangeset = new Changeset(id != null ? id.intValue() : 0);
            while (true) {
                int event;
                if ((event = this.parser.next()) == 1) {
                    if ("tag".equals(this.parser.getLocalName())) {
                        this.parseTag(this.uploadChangeset);
                        continue;
                    }
                    this.parseUnknown();
                    continue;
                }
                if (event == 2) break;
            }
            return;
        }
        this.jumpToEnd(false);
    }

    private void parseTag(Tagged t) throws XMLStreamException {
        String key = this.parser.getAttributeValue(null, "k");
        String value = this.parser.getAttributeValue(null, "v");
        if (key == null || value == null) {
            this.throwException(I18n.tr("Missing key or value attribute in tag.", new Object[0]));
        }
        t.put(key.intern(), value.intern());
        this.jumpToEnd();
    }

    protected void parseUnknown(boolean printWarning) throws XMLStreamException {
        if (printWarning) {
            Main.info(I18n.tr("Undefined element ''{0}'' found in input stream. Skipping.", this.parser.getLocalName()));
        }
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                this.parseUnknown(false);
                continue;
            }
            if (event == 2) break;
        }
    }

    protected void parseUnknown() throws XMLStreamException {
        this.parseUnknown(true);
    }

    private void jumpToEnd(boolean printWarning) throws XMLStreamException {
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                this.parseUnknown(printWarning);
                continue;
            }
            if (event == 2) break;
        }
    }

    private void jumpToEnd() throws XMLStreamException {
        this.jumpToEnd(true);
    }

    private User createUser(String uid, String name) throws XMLStreamException {
        if (uid == null) {
            if (name == null) {
                return null;
            }
            return User.createLocalUser(name);
        }
        try {
            long id = Long.parseLong(uid);
            return User.createOsmUser(id, name);
        }
        catch (NumberFormatException e) {
            this.throwException(MessageFormat.format("Illegal value for attribute ''uid''. Got ''{0}''.", uid), e);
            return null;
        }
    }

    private void readCommon(PrimitiveData current) throws XMLStreamException {
        String v;
        int version;
        block29: {
            block28: {
                String time;
                current.setId(this.getLong("id"));
                if (current.getUniqueId() == 0L) {
                    this.throwException(I18n.tr("Illegal object with ID=0.", new Object[0]));
                }
                if ((time = this.parser.getAttributeValue(null, "timestamp")) != null && time.length() != 0) {
                    current.setTimestamp(DateUtils.fromString(time));
                }
                String user = this.parser.getAttributeValue(null, "user");
                String uid = this.parser.getAttributeValue(null, "uid");
                current.setUser(this.createUser(uid, user));
                String visible = this.parser.getAttributeValue(null, "visible");
                if (visible != null) {
                    current.setVisible(Boolean.parseBoolean(visible));
                }
                String versionString = this.parser.getAttributeValue(null, "version");
                version = 0;
                if (versionString == null) break block28;
                try {
                    version = Integer.parseInt(versionString);
                }
                catch (NumberFormatException e) {
                    this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(current.getUniqueId()), versionString), e);
                }
                switch (this.ds.getVersion()) {
                    case "0.6": {
                        if (version <= 0 && !current.isNew()) {
                            this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(current.getUniqueId()), versionString));
                            break;
                        }
                        if (version < 0 && current.isNew()) {
                            Main.warn(I18n.tr("Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", current.getUniqueId(), version, 0, "0.6"));
                            version = 0;
                            break;
                        }
                        break block29;
                    }
                    default: {
                        this.throwException(I18n.tr("Unknown or unsupported API version. Got {0}.", this.ds.getVersion()));
                        break;
                    }
                }
                break block29;
            }
            if (!current.isNew() && this.ds.getVersion() != null && "0.6".equals(this.ds.getVersion())) {
                this.throwException(I18n.tr("Missing attribute ''version'' on OSM primitive with ID {0}.", Long.toString(current.getUniqueId())));
            }
        }
        current.setVersion(version);
        String action = this.parser.getAttributeValue(null, "action");
        if (action != null) {
            if ("delete".equals(action)) {
                current.setDeleted(true);
                current.setModified(current.isVisible());
            } else if ("modify".equals(action)) {
                current.setModified(true);
            }
        }
        if ((v = this.parser.getAttributeValue(null, "changeset")) == null) {
            current.setChangesetId(0);
        } else {
            try {
                current.setChangesetId(Integer.parseInt(v));
            }
            catch (IllegalArgumentException e) {
                Main.debug(e.getMessage());
                if (current.isNew()) {
                    Main.info(I18n.tr("Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", v, current.getUniqueId()));
                    current.setChangesetId(0);
                } else {
                    this.throwException(I18n.tr("Illegal value for attribute ''changeset''. Got {0}.", v), e);
                }
            }
            catch (IllegalStateException e) {
                Main.info(e.getMessage());
                current.setChangesetId(0);
            }
            if (current.getChangesetId() <= 0) {
                if (current.isNew()) {
                    Main.info(I18n.tr("Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", v, current.getUniqueId()));
                    current.setChangesetId(0);
                } else {
                    this.throwException(I18n.tr("Illegal value for attribute ''changeset''. Got {0}.", v));
                }
            }
        }
    }

    private long getLong(String name) throws XMLStreamException {
        String value = this.parser.getAttributeValue(null, name);
        if (value == null) {
            this.throwException(I18n.tr("Missing required attribute ''{0}''.", name));
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            this.throwException(I18n.tr("Illegal long value for attribute ''{0}''. Got ''{1}''.", name, value), e);
            return 0L;
        }
    }

    protected DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        ProgressMonitor.CancelListener cancelListener = new ProgressMonitor.CancelListener(){

            @Override
            public void operationCanceled() {
                OsmReader.this.cancel = true;
            }
        };
        progressMonitor.addCancelListener(cancelListener);
        CheckParameterUtil.ensureParameterNotNull(source, "source");
        try {
            progressMonitor.beginTask(I18n.tr("Prepare OSM data...", 2));
            progressMonitor.indeterminateSubTask(I18n.tr("Parsing OSM data...", new Object[0]));
            try (UTFInputStreamReader ir = UTFInputStreamReader.create(source);){
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(ir);
                this.setParser(parser);
                this.parse();
            }
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Preparing data set...", new Object[0]));
            this.prepareDataSet();
            progressMonitor.worked(1);
            if (postprocessors != null) {
                for (OsmServerReadPostprocessor pp : postprocessors) {
                    pp.postprocessDataSet(this.getDataSet(), progressMonitor);
                }
            }
            DataSet i$ = this.getDataSet();
            return i$;
        }
        catch (IllegalDataException e) {
            throw e;
        }
        catch (OsmParsingException e) {
            throw new IllegalDataException(e.getMessage(), e);
        }
        catch (XMLStreamException e) {
            String msg = e.getMessage();
            Pattern p = Pattern.compile("Message: (.+)");
            Matcher m = p.matcher(msg);
            if (m.find()) {
                msg = m.group(1);
            }
            if (e.getLocation() != null) {
                throw new IllegalDataException(I18n.tr("Line {0} column {1}: ", e.getLocation().getLineNumber(), e.getLocation().getColumnNumber()) + msg, e);
            }
            throw new IllegalDataException(msg, e);
        }
        catch (Exception e) {
            throw new IllegalDataException(e);
        }
        finally {
            progressMonitor.finishTask();
            progressMonitor.removeCancelListener(cancelListener);
        }
    }

    public static DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return new OsmReader().doParseDataSet(source, progressMonitor);
    }

    private static final class OsmParsingCanceledException
    extends OsmParsingException
    implements ImportCancelException {
        public OsmParsingCanceledException(String msg, Location location) {
            super(msg, location);
        }
    }

    private static class OsmParsingException
    extends XMLStreamException {
        public OsmParsingException(String msg, Location location) {
            super(msg);
            this.location = location;
        }

        public OsmParsingException(String msg, Location location, Throwable th) {
            super(msg, th);
            this.location = location;
        }

        @Override
        public String getMessage() {
            String msg = super.getMessage();
            if (msg == null) {
                msg = this.getClass().getName();
            }
            if (this.getLocation() == null) {
                return msg;
            }
            msg = msg + " " + I18n.tr("(at line {0}, column {1})", this.getLocation().getLineNumber(), this.getLocation().getColumnNumber());
            int offset = this.getLocation().getCharacterOffset();
            if (offset > -1) {
                msg = msg + ". " + I18n.tr("{0} bytes have been read", offset);
            }
            return msg;
        }
    }
}

