/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.I18n;

public class OsmImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("osm,xml", "osm", I18n.tr("OSM Server Files", new Object[0]) + " (*.osm *.xml)");

    public OsmImporter() {
        super(FILE_FILTER);
    }

    public OsmImporter(ExtensionFileFilter filter) {
        super(filter);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        try (InputStream in = Compression.getUncompressedFileInputStream(file);){
            this.importData(in, file, progressMonitor);
        }
        catch (FileNotFoundException e) {
            Main.error(e);
            throw new IOException(I18n.tr("File ''{0}'' does not exist.", file.getName()), e);
        }
    }

    protected void importData(InputStream in, File associatedFile) throws IllegalDataException {
        this.importData(in, associatedFile, NullProgressMonitor.INSTANCE);
    }

    protected void importData(InputStream in, File associatedFile, ProgressMonitor pm) throws IllegalDataException {
        final OsmImporterData data = this.loadLayer(in, associatedFile, associatedFile == null ? OsmDataLayer.createNewName() : associatedFile.getName(), pm);
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                OsmDataLayer layer = data.getLayer();
                BoundingXYVisitor v = new BoundingXYVisitor();
                v.visit(layer.data.getDataSourceBoundingBox());
                if (!v.hasExtend()) {
                    v.computeBoundingBox(layer.data.getNodes());
                }
                Main.main.addLayer((Layer)layer, v.getBounds());
                data.getPostLayerTask().run();
                data.getLayer().onPostLoadFromFile();
            }
        });
    }

    public OsmImporterData loadLayer(InputStream in, File associatedFile, String layerName, ProgressMonitor progressMonitor) throws IllegalDataException {
        DataSet dataSet = this.parseDataSet(in, progressMonitor);
        if (dataSet == null) {
            throw new IllegalDataException(I18n.tr("Invalid dataset", new Object[0]));
        }
        OsmDataLayer layer = this.createLayer(dataSet, associatedFile, layerName);
        Runnable postLayerTask = this.createPostLayerTask(dataSet, associatedFile, layerName, layer);
        return new OsmImporterData(layer, postLayerTask);
    }

    protected DataSet parseDataSet(InputStream in, ProgressMonitor progressMonitor) throws IllegalDataException {
        return OsmReader.parseDataSet(in, progressMonitor);
    }

    protected OsmDataLayer createLayer(DataSet dataSet, File associatedFile, String layerName) {
        return new OsmDataLayer(dataSet, layerName, associatedFile);
    }

    protected Runnable createPostLayerTask(final DataSet dataSet, final File associatedFile, final String layerName, final OsmDataLayer layer) {
        return new Runnable(){

            @Override
            public void run() {
                if (dataSet.allPrimitives().isEmpty()) {
                    String msg = associatedFile == null ? I18n.tr("No data found for layer ''{0}''.", layerName) : I18n.tr("No data found in file ''{0}''.", associatedFile.getPath());
                    JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("Open OSM file", new Object[0]), 1);
                }
                layer.onPostLoadFromFile();
            }
        };
    }

    public static class OsmImporterData {
        private final OsmDataLayer layer;
        private final Runnable postLayerTask;

        public OsmImporterData(OsmDataLayer layer, Runnable postLayerTask) {
            this.layer = layer;
            this.postLayerTask = postLayerTask;
        }

        public OsmDataLayer getLayer() {
            return this.layer;
        }

        public Runnable getPostLayerTask() {
            return this.postLayerTask;
        }
    }
}

