/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.OsmImporter;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmExporter
extends FileExporter {
    public OsmExporter() {
        super(OsmImporter.FILE_FILTER);
    }

    public OsmExporter(ExtensionFileFilter filter) {
        super(filter);
    }

    @Override
    public boolean acceptFile(File pathname, Layer layer) {
        if (!(layer instanceof OsmDataLayer)) {
            return false;
        }
        return super.acceptFile(pathname, layer);
    }

    @Override
    public void exportData(File file, Layer layer) throws IOException {
        this.exportData(file, layer, false);
    }

    public void exportData(File file, Layer layer, boolean noBackup) throws IllegalArgumentException {
        OsmExporter.checkOsmDataLayer(layer);
        this.save(file, (OsmDataLayer)layer, noBackup);
    }

    protected static void checkOsmDataLayer(Layer layer) throws IllegalArgumentException {
        if (!(layer instanceof OsmDataLayer)) {
            throw new IllegalArgumentException(MessageFormat.format("Expected instance of OsmDataLayer. Got ''{0}''.", layer.getClass().getName()));
        }
    }

    protected static OutputStream getOutputStream(File file) throws FileNotFoundException, IOException {
        return Compression.getCompressedFileOutputStream(file);
    }

    private void save(File file, OsmDataLayer layer, boolean noBackup) {
        File tmpFile = null;
        try {
            if (file.exists()) {
                tmpFile = new File(file.getPath() + "~");
                Utils.copyFile(file, tmpFile);
            }
            this.doSave(file, layer);
            if ((noBackup || !Main.pref.getBoolean("save.keepbackup", false)) && tmpFile != null) {
                tmpFile.delete();
            }
            layer.onPostSaveToFile();
        }
        catch (IOException e) {
            Main.error(e);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while saving.<br>Error is:<br>{0}</html>", e.getMessage()), I18n.tr("Error", new Object[0]), 0);
            try {
                if (tmpFile != null && tmpFile.exists()) {
                    Utils.copyFile(tmpFile, file);
                }
            }
            catch (IOException e2) {
                Main.error(e2);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while restoring backup file.<br>Error is:<br>{0}</html>", e2.getMessage()), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSave(File file, OsmDataLayer layer) throws IOException, FileNotFoundException {
        try (OutputStream out = OsmExporter.getOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
             OsmWriter w = OsmWriterFactory.createOsmWriter(new PrintWriter(writer), false, layer.data.getVersion());){
            layer.data.getReadLock().lock();
            try {
                w.writeLayer(layer);
            }
            finally {
                layer.data.getReadLock().unlock();
            }
        }
    }
}

