/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.exception.OAuthException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.io.MissingOAuthAccessTokenException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.I18n;

public class OsmConnection {
    protected boolean cancel = false;
    protected HttpURLConnection activeConnection;
    protected OAuthParameters oauthParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.cancel = true;
        OsmConnection osmConnection = this;
        synchronized (osmConnection) {
            if (this.activeConnection != null) {
                this.activeConnection.setConnectTimeout(100);
                this.activeConnection.setReadTimeout(100);
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            Main.warn("InterruptedException in " + this.getClass().getSimpleName() + " during cancel");
        }
        osmConnection = this;
        synchronized (osmConnection) {
            if (this.activeConnection != null) {
                this.activeConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBasicAuthorizationHeader(HttpURLConnection con) throws OsmTransferException {
        CredentialsAgentResponse response;
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        try {
            CredentialsManager credentialsManager = CredentialsManager.getInstance();
            synchronized (credentialsManager) {
                response = CredentialsManager.getInstance().getCredentials(Authenticator.RequestorType.SERVER, con.getURL().getHost(), false);
            }
        }
        catch (CredentialsAgentException e) {
            throw new OsmTransferException(e);
        }
        if (response == null) {
            String token = ":";
        } else {
            if (response.isCanceled()) {
                this.cancel = true;
                return;
            }
            String username = response.getUsername() == null ? "" : response.getUsername();
            String password = response.getPassword() == null ? "" : String.valueOf(response.getPassword());
            String token = username + ":" + password;
            try {
                ByteBuffer bytes = encoder.encode(CharBuffer.wrap(token));
                con.addRequestProperty("Authorization", "Basic " + Base64.encode(bytes));
            }
            catch (CharacterCodingException e) {
                throw new OsmTransferException(e);
            }
        }
    }

    protected void addOAuthAuthorizationHeader(HttpURLConnection connection) throws OsmTransferException {
        if (this.oauthParameters == null) {
            this.oauthParameters = OAuthParameters.createFromPreferences(Main.pref);
        }
        OAuthConsumer consumer = this.oauthParameters.buildConsumer();
        OAuthAccessTokenHolder holder = OAuthAccessTokenHolder.getInstance();
        if (!holder.containsAccessToken()) {
            throw new MissingOAuthAccessTokenException();
        }
        consumer.setTokenWithSecret(holder.getAccessTokenKey(), holder.getAccessTokenSecret());
        try {
            consumer.sign(connection);
        }
        catch (OAuthException e) {
            throw new OsmTransferException(I18n.tr("Failed to sign a HTTP connection with an OAuth Authentication header", new Object[0]), e);
        }
    }

    protected void addAuth(HttpURLConnection connection) throws OsmTransferException {
        String authMethod = Main.pref.get("osm-server.auth-method", "basic");
        if ("basic".equals(authMethod)) {
            this.addBasicAuthorizationHeader(connection);
        } else if ("oauth".equals(authMethod)) {
            this.addOAuthAuthorizationHeader(connection);
        } else {
            String msg = I18n.tr("Unexpected value for preference ''{0}''. Got ''{1}''.", "osm-server.auth-method", authMethod);
            Main.warn(msg);
            throw new OsmTransferException(msg);
        }
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    static {
        try {
            HttpURLConnection.setFollowRedirects(true);
        }
        catch (SecurityException e) {
            Main.error(e);
        }
    }
}

