/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetDiscussionComment;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.InvalidXmlCharacterFilter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class OsmChangesetParser {
    private final List<Changeset> changesets = new LinkedList<Changeset>();

    private OsmChangesetParser() {
    }

    public List<Changeset> getChangesets() {
        return this.changesets;
    }

    public static List<Changeset> parse(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        OsmChangesetParser parser = new OsmChangesetParser();
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Parsing list of changesets...", new Object[0]));
            InputSource inputSource = new InputSource(new InvalidXmlCharacterFilter(new InputStreamReader(source, StandardCharsets.UTF_8)));
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            OsmChangesetParser osmChangesetParser = parser;
            osmChangesetParser.getClass();
            sAXParser.parse(inputSource, (DefaultHandler)osmChangesetParser.new Parser());
            List<Changeset> list = parser.getChangesets();
            return list;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IllegalDataException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new IllegalDataException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private class Parser
    extends DefaultHandler {
        private Locator locator;
        private Changeset current = null;
        private ChangesetDiscussionComment comment = null;
        private StringBuilder text = null;

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String msg) throws XmlParsingException {
            throw new XmlParsingException(msg).rememberLocation(this.locator);
        }

        protected void parseChangesetAttributes(Changeset cs, Attributes atts) throws XmlParsingException {
            String commentsCount;
            String value = atts.getValue("id");
            if (value == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "id"));
            }
            this.current.setId(this.parseNumericAttribute(value, 1));
            this.current.setUser(this.createUser(atts));
            value = atts.getValue("created_at");
            if (value == null) {
                this.current.setCreatedAt(null);
            } else {
                this.current.setCreatedAt(DateUtils.fromString(value));
            }
            value = atts.getValue("closed_at");
            if (value == null) {
                this.current.setClosedAt(null);
            } else {
                this.current.setClosedAt(DateUtils.fromString(value));
            }
            value = atts.getValue("open");
            if (value == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "open"));
            } else if ("true".equals(value)) {
                this.current.setOpen(true);
            } else if ("false".equals(value)) {
                this.current.setOpen(false);
            } else {
                this.throwException(I18n.tr("Illegal boolean value for attribute ''{0}''. Got ''{1}''.", "open", value));
            }
            String min_lon = atts.getValue("min_lon");
            String min_lat = atts.getValue("min_lat");
            String max_lon = atts.getValue("max_lon");
            String max_lat = atts.getValue("max_lat");
            if (min_lon != null && min_lat != null && max_lon != null && max_lat != null) {
                double minLon = 0.0;
                try {
                    minLon = Double.parseDouble(min_lon);
                }
                catch (NumberFormatException e) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "min_lon", min_lon));
                }
                double minLat = 0.0;
                try {
                    minLat = Double.parseDouble(min_lat);
                }
                catch (NumberFormatException e) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "min_lat", min_lat));
                }
                this.current.setMin(new LatLon(minLat, minLon));
                double maxLon = 0.0;
                try {
                    maxLon = Double.parseDouble(max_lon);
                }
                catch (NumberFormatException e) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "max_lon", max_lon));
                }
                double maxLat = 0.0;
                try {
                    maxLat = Double.parseDouble(max_lat);
                }
                catch (NumberFormatException e) {
                    this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "max_lat", max_lat));
                }
                this.current.setMax(new LatLon(maxLon, maxLat));
            }
            if ((commentsCount = atts.getValue("comments_count")) != null) {
                this.current.setCommentsCount(this.parseNumericAttribute(commentsCount, 0));
            }
        }

        private void parseCommentAttributes(Attributes atts) throws XmlParsingException {
            String value = atts.getValue("date");
            Date date = null;
            if (value != null) {
                date = DateUtils.fromString(value);
            }
            this.comment = new ChangesetDiscussionComment(date, this.createUser(atts));
        }

        private int parseNumericAttribute(String value, int minAllowed) throws XmlParsingException {
            int att = 0;
            try {
                att = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr("Illegal value for attribute ''{0}''. Got ''{1}''.", "id", value));
            }
            if (att < minAllowed) {
                this.throwException(I18n.tr("Illegal numeric value for attribute ''{0}''. Got ''{1}''.", "id", att));
            }
            return att;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            switch (qName) {
                case "osm": {
                    if (atts == null) {
                        this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' of XML element {1}.", "version", "osm"));
                        return;
                    }
                    String v = atts.getValue("version");
                    if (v == null) {
                        this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
                    }
                    if ("0.6".equals(v)) break;
                    this.throwException(I18n.tr("Unsupported version: {0}", v));
                    break;
                }
                case "changeset": {
                    this.current = new Changeset();
                    this.parseChangesetAttributes(this.current, atts);
                    break;
                }
                case "tag": {
                    String key = atts.getValue("k");
                    String value = atts.getValue("v");
                    this.current.put(key, value);
                    break;
                }
                case "discussion": {
                    break;
                }
                case "comment": {
                    this.parseCommentAttributes(atts);
                    break;
                }
                case "text": {
                    this.text = new StringBuilder();
                    break;
                }
                default: {
                    this.throwException(I18n.tr("Undefined element ''{0}'' found in input stream. Aborting.", qName));
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.text != null) {
                this.text.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("changeset".equals(qName)) {
                OsmChangesetParser.this.changesets.add(this.current);
                this.current = null;
            } else if ("comment".equals(qName)) {
                this.current.addDiscussionComment(this.comment);
                this.comment = null;
            } else if ("text".equals(qName)) {
                this.comment.setText(this.text.toString());
                this.text = null;
            }
        }

        protected User createUser(Attributes atts) throws XmlParsingException {
            String name = atts.getValue("user");
            String uid = atts.getValue("uid");
            if (uid == null) {
                if (name == null) {
                    return null;
                }
                return User.createLocalUser(name);
            }
            try {
                long id = Long.parseLong(uid);
                return User.createOsmUser(id, name);
            }
            catch (NumberFormatException e) {
                this.throwException(MessageFormat.format("Illegal value for attribute ''uid''. Got ''{0}''.", uid));
                return null;
            }
        }
    }
}

