/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmChangeReader;
import org.openstreetmap.josm.tools.I18n;

public class OsmChangeImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("osc,osc.bz2,osc.bz,osc.gz", "osc", I18n.tr("OsmChange File", new Object[0]) + " (*.osc *.osc.bz2 *.osc.bz *.osc.gz)");

    public OsmChangeImporter() {
        super(FILE_FILTER);
    }

    public OsmChangeImporter(ExtensionFileFilter filter) {
        super(filter);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        try {
            this.importData(Compression.getUncompressedFileInputStream(file), file, progressMonitor);
        }
        catch (FileNotFoundException e) {
            Main.error(e);
            throw new IOException(I18n.tr("File ''{0}'' does not exist.", file.getName()));
        }
    }

    protected void importData(InputStream in, File associatedFile) throws IllegalDataException {
        this.importData(in, associatedFile, NullProgressMonitor.INSTANCE);
    }

    protected void importData(InputStream in, File associatedFile, ProgressMonitor progressMonitor) throws IllegalDataException {
        DataSet dataSet = OsmChangeReader.parseDataSet(in, progressMonitor);
        OsmDataLayer layer = new OsmDataLayer(dataSet, associatedFile.getName(), associatedFile);
        this.addDataLayer(dataSet, layer, associatedFile.getPath());
    }

    protected void addDataLayer(final DataSet dataSet, final OsmDataLayer layer, final String filePath) {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (dataSet.allPrimitives().isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("No data found in file {0}.", filePath), I18n.tr("Open OsmChange file", new Object[0]), 1);
                }
                Main.main.addLayer(layer);
                layer.onPostLoadFromFile();
            }
        });
    }
}

