/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class OsmApiException
extends OsmTransferException {
    private int responseCode;
    private String errorHeader;
    private String errorBody;
    private String accessedUrl;

    public OsmApiException(int responseCode, String errorHeader, String errorBody, String accessedUrl) {
        this.responseCode = responseCode;
        this.errorHeader = errorHeader;
        this.errorBody = errorBody;
        this.accessedUrl = accessedUrl;
    }

    public OsmApiException(int responseCode, String errorHeader, String errorBody) {
        this(responseCode, errorHeader, errorBody, null);
    }

    public OsmApiException(String message) {
        super(message);
    }

    public OsmApiException(Throwable cause) {
        super(cause);
    }

    public OsmApiException(String message, Throwable cause) {
        super(message, cause);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getErrorHeader() {
        return this.errorHeader;
    }

    public void setErrorHeader(String errorHeader) {
        this.errorHeader = errorHeader;
    }

    public String getErrorBody() {
        return this.errorBody;
    }

    public void setErrorBody(String errorBody) {
        this.errorBody = errorBody;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResponseCode=").append(this.responseCode);
        String eh = "";
        try {
            if (this.errorHeader != null) {
                eh = I18n.tr(this.errorHeader.trim(), new Object[0]);
            }
            if (!eh.isEmpty()) {
                sb.append(", Error Header=<").append(eh).append(">");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String eb;
            String string = eb = this.errorBody != null ? I18n.tr(this.errorBody.trim(), new Object[0]) : "";
            if (!eb.isEmpty() && !eb.equals(eh)) {
                sb.append(", Error Body=<").append(eb).append(">");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public String getDisplayMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.errorHeader != null) {
            sb.append(I18n.tr(this.errorHeader, new Object[0]));
            sb.append(I18n.tr("(Code={0})", this.responseCode));
        } else if (this.errorBody != null && !this.errorBody.trim().isEmpty()) {
            this.errorBody = this.errorBody.trim();
            sb.append(I18n.tr(this.errorBody, new Object[0]));
            sb.append(I18n.tr("(Code={0})", this.responseCode));
        } else {
            sb.append(I18n.tr("The server replied an error with code {0}.", this.responseCode));
        }
        return sb.toString();
    }

    public void setAccessedUrl(String url) {
        this.accessedUrl = url;
    }

    public String getAccessedUrl() {
        return this.accessedUrl;
    }
}

