/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.io.XmlWriter;

public class NoteWriter
extends XmlWriter {
    private final SimpleDateFormat ISO8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX", Locale.ENGLISH);

    public NoteWriter(PrintWriter out) {
        super(out);
    }

    public NoteWriter(OutputStream out) {
        super(new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8))));
    }

    public void write(NoteData data) {
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.out.println("<osm-notes>");
        for (Note note : data.getNotes()) {
            this.out.print("  <note ");
            this.out.print("id=\"" + note.getId() + "\" ");
            this.out.print("lat=\"" + note.getLatLon().lat() + "\" ");
            this.out.print("lon=\"" + note.getLatLon().lon() + "\" ");
            this.out.print("created_at=\"" + this.ISO8601_FORMAT.format(note.getCreatedAt()) + "\" ");
            if (note.getClosedAt() != null) {
                this.out.print("closed_at=\"" + this.ISO8601_FORMAT.format(note.getClosedAt()) + "\" ");
            }
            this.out.println(">");
            for (NoteComment comment : note.getComments()) {
                this.writeComment(comment);
            }
            this.out.println("  </note>");
        }
        this.out.println("</osm-notes>");
        this.out.flush();
    }

    private void writeComment(NoteComment comment) {
        this.out.print("    <comment");
        this.out.print(" action=\"" + (Object)((Object)comment.getNoteAction()) + "\" ");
        this.out.print("timestamp=\"" + this.ISO8601_FORMAT.format(comment.getCommentTimestamp()) + "\" ");
        if (comment.getUser() != null && !comment.getUser().equals(User.getAnonymous())) {
            this.out.print("uid=\"" + comment.getUser().getId() + "\" ");
            this.out.print("user=\"" + NoteWriter.encode(comment.getUser().getName()) + "\" ");
        }
        this.out.print("is_new=\"" + comment.getIsNew() + "\" ");
        this.out.print(">");
        this.out.print(NoteWriter.encode(comment.getText(), false));
        this.out.println("</comment>");
    }
}

