/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.User;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NoteReader {
    private InputSource inputSource;
    private List<Note> parsedNotes;

    public NoteReader(InputStream source) throws IOException {
        this.inputSource = new InputSource(source);
    }

    public NoteReader(String source) throws IOException {
        this.inputSource = new InputSource(new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8)));
    }

    public List<Note> parse() throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.newSAXParser().parse(this.inputSource, (DefaultHandler)parser);
        }
        catch (ParserConfigurationException e) {
            Main.error(e);
            throw new SAXException(e);
        }
        return this.parsedNotes;
    }

    private class Parser
    extends DefaultHandler {
        private final SimpleDateFormat ISO8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX", Locale.ENGLISH);
        private final SimpleDateFormat NOTE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.ENGLISH);
        private NoteParseMode parseMode;
        private StringBuffer buffer = new StringBuffer();
        private Note thisNote;
        private long commentUid;
        private String commentUsername;
        private NoteComment.Action noteAction;
        private Date commentCreateDate;
        private Boolean commentIsNew;
        private List<Note> notes;
        String commentText;

        private Parser() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            this.buffer.setLength(0);
            switch (qName) {
                case "osm": {
                    this.parseMode = NoteParseMode.API;
                    this.notes = new ArrayList<Note>(100);
                    return;
                }
                case "osm-notes": {
                    this.parseMode = NoteParseMode.DUMP;
                    this.notes = new ArrayList<Note>(10000);
                    return;
                }
            }
            if (this.parseMode == NoteParseMode.API) {
                if ("note".equals(qName)) {
                    double lat = Double.parseDouble(attrs.getValue("lat"));
                    double lon = Double.parseDouble(attrs.getValue("lon"));
                    LatLon noteLatLon = new LatLon(lat, lon);
                    this.thisNote = new Note(noteLatLon);
                }
                return;
            }
            switch (qName) {
                case "note": {
                    double lat = Double.parseDouble(attrs.getValue("lat"));
                    double lon = Double.parseDouble(attrs.getValue("lon"));
                    LatLon noteLatLon = new LatLon(lat, lon);
                    this.thisNote = new Note(noteLatLon);
                    this.thisNote.setId(Long.parseLong(attrs.getValue("id")));
                    String closedTimeStr = attrs.getValue("closed_at");
                    if (closedTimeStr == null) {
                        this.thisNote.setState(Note.State.open);
                    } else {
                        this.thisNote.setState(Note.State.closed);
                        this.thisNote.setClosedAt(this.parseDate(this.ISO8601_FORMAT, closedTimeStr));
                    }
                    this.thisNote.setCreatedAt(this.parseDate(this.ISO8601_FORMAT, attrs.getValue("created_at")));
                    break;
                }
                case "comment": {
                    String uidStr = attrs.getValue("uid");
                    this.commentUid = uidStr == null ? 0L : Long.parseLong(uidStr);
                    this.commentUsername = attrs.getValue("user");
                    this.noteAction = NoteComment.Action.valueOf(attrs.getValue("action"));
                    this.commentCreateDate = this.parseDate(this.ISO8601_FORMAT, attrs.getValue("timestamp"));
                    String isNew = attrs.getValue("is_new");
                    this.commentIsNew = isNew == null ? Boolean.valueOf(false) : Boolean.valueOf(isNew);
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if ("note".equals(qName)) {
                this.notes.add(this.thisNote);
            }
            if ("comment".equals(qName)) {
                User commentUser = User.createOsmUser(this.commentUid, this.commentUsername);
                if (this.commentUid == 0L) {
                    commentUser = User.getAnonymous();
                }
                if (this.parseMode == NoteParseMode.API) {
                    this.commentIsNew = false;
                }
                if (this.parseMode == NoteParseMode.DUMP) {
                    this.commentText = this.buffer.toString();
                }
                this.thisNote.addComment(new NoteComment(this.commentCreateDate, commentUser, this.commentText, this.noteAction, this.commentIsNew));
                this.commentUid = 0L;
                this.commentUsername = null;
                this.commentCreateDate = null;
                this.commentIsNew = null;
                this.commentText = null;
            }
            if (this.parseMode == NoteParseMode.DUMP) {
                return;
            }
            switch (qName) {
                case "id": {
                    this.thisNote.setId(Long.parseLong(this.buffer.toString()));
                    break;
                }
                case "status": {
                    this.thisNote.setState(Note.State.valueOf(this.buffer.toString()));
                    break;
                }
                case "date_created": {
                    this.thisNote.setCreatedAt(this.parseDate(this.NOTE_DATE_FORMAT, this.buffer.toString()));
                    break;
                }
                case "date_closed": {
                    this.thisNote.setClosedAt(this.parseDate(this.NOTE_DATE_FORMAT, this.buffer.toString()));
                    break;
                }
                case "date": {
                    this.commentCreateDate = this.parseDate(this.NOTE_DATE_FORMAT, this.buffer.toString());
                    break;
                }
                case "user": {
                    this.commentUsername = this.buffer.toString();
                    break;
                }
                case "uid": {
                    this.commentUid = Long.parseLong(this.buffer.toString());
                    break;
                }
                case "text": {
                    this.commentText = this.buffer.toString();
                    this.buffer.setLength(0);
                    break;
                }
                case "action": {
                    this.noteAction = NoteComment.Action.valueOf(this.buffer.toString());
                    break;
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            Main.info("parsed notes: " + this.notes.size());
            NoteReader.this.parsedNotes = this.notes;
        }

        private Date parseDate(SimpleDateFormat sdf, String dateStr) {
            try {
                return sdf.parse(dateStr);
            }
            catch (ParseException e) {
                Main.error("error parsing date in note parser");
                return null;
            }
        }
    }

    private static enum NoteParseMode {
        API,
        DUMP;

    }
}

