/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.NoteWriter;
import org.openstreetmap.josm.tools.I18n;

public class NoteExporter
extends FileExporter {
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("osn", "osn", I18n.tr("Note Files", new Object[0]) + " (*.osn)");

    public NoteExporter() {
        super(FILE_FILTER);
    }

    @Override
    public boolean acceptFile(File pathname, Layer layer) {
        if (!(layer instanceof NoteLayer)) {
            return false;
        }
        return super.acceptFile(pathname, layer);
    }

    @Override
    public void exportData(File file, Layer layer) throws IOException {
        Main.info("exporting notes to file: " + file);
        if (layer instanceof NoteLayer) {
            FileOutputStream os = new FileOutputStream(file);
            NoteWriter writer = new NoteWriter(os);
            writer.write(((NoteLayer)layer).getNoteData());
            os.flush();
            writer.close();
        }
    }
}

