/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.GpxImporter;
import org.openstreetmap.josm.io.NmeaReader;
import org.openstreetmap.josm.tools.I18n;

public class NMEAImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("nmea,nme,nma,log,txt", "nmea", I18n.tr("NMEA-0183 Files", new Object[0]) + " (*.nmea *.nme *.nma *.log *.txt)");

    public NMEAImporter() {
        super(FILE_FILTER);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        final String fn = file.getName();
        try (FileInputStream fis = new FileInputStream(file);){
            final NmeaReader r = new NmeaReader(fis);
            if (r.getNumberOfCoordinates() > 0) {
                r.data.storageFile = file;
                final GpxLayer gpxLayer = new GpxLayer(r.data, fn, true);
                final File fileFinal = file;
                GuiHelper.runInEDT(new Runnable(){

                    @Override
                    public void run() {
                        Main.main.addLayer(gpxLayer);
                        if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
                            MarkerLayer ml = new MarkerLayer(r.data, I18n.tr("Markers from {0}", fn), fileFinal, gpxLayer);
                            if (!ml.data.isEmpty()) {
                                Main.main.addLayer(ml);
                            }
                        }
                    }
                });
            }
            this.showNmeaInfobox(r.getNumberOfCoordinates() > 0, r);
        }
    }

    private void showNmeaInfobox(boolean success, NmeaReader r) {
        final StringBuilder msg = new StringBuilder().append("<html>");
        msg.append(I18n.tr("Coordinates imported: {0}", r.getNumberOfCoordinates()) + "<br>");
        msg.append(I18n.tr("Malformed sentences: {0}", r.getParserMalformed()) + "<br>");
        msg.append(I18n.tr("Checksum errors: {0}", r.getParserChecksumErrors()) + "<br>");
        if (!success) {
            msg.append(I18n.tr("Unknown sentences: {0}", r.getParserUnknown()) + "<br>");
        }
        msg.append(I18n.tr("Zero coordinates: {0}", r.getParserZeroCoordinates()));
        msg.append("</html>");
        if (success) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new Notification("<h3>" + I18n.tr("NMEA import success:", new Object[0]) + "</h3>" + msg.toString()).setIcon(1).show();
                }
            });
        } else {
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, msg.toString(), I18n.tr("NMEA import failure!", new Object[0]), 0, null);
        }
    }

    public static GpxImporter.GpxImporterData loadLayers(InputStream is, File associatedFile, String gpxLayerName, String markerLayerName) throws IOException {
        NmeaReader r = new NmeaReader(is);
        boolean parsedProperly = r.getNumberOfCoordinates() > 0;
        r.data.storageFile = associatedFile;
        return GpxImporter.loadLayers(r.data, parsedProperly, gpxLayerName, markerLayerName);
    }
}

