/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.net.Authenticator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.JosmPreferencesCredentialAgent;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public final class MessageNotifier {
    public static final BooleanProperty PROP_NOTIFIER_ENABLED = new BooleanProperty("message.notifier.enabled", true);
    public static final IntegerProperty PROP_INTERVAL = new IntegerProperty("message.notifier.interval", 5);
    private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private static final Runnable WORKER = new Worker();
    private static volatile ScheduledFuture<?> task = null;

    public static void start() {
        int interval = PROP_INTERVAL.get();
        if (Main.isOffline(OnlineResource.OSM_API)) {
            Main.info(I18n.tr("{0} not available (offline mode)", I18n.tr("Message notifier", new Object[0])));
        } else if (!MessageNotifier.isRunning() && interval > 0 && MessageNotifier.isUserEnoughIdentified()) {
            task = EXECUTOR.scheduleAtFixedRate(WORKER, 0L, interval * 60, TimeUnit.SECONDS);
            Main.info("Message notifier active (checks every " + interval + " minute" + (interval > 1 ? "s" : "") + ")");
        }
    }

    public static void stop() {
        if (MessageNotifier.isRunning()) {
            task.cancel(false);
            Main.info("Message notifier inactive");
            task = null;
        }
    }

    public static boolean isRunning() {
        return task != null;
    }

    public static boolean isUserEnoughIdentified() {
        JosmUserIdentityManager identManager = JosmUserIdentityManager.getInstance();
        if (identManager.isFullyIdentified()) {
            return true;
        }
        CredentialsManager credManager = CredentialsManager.getInstance();
        try {
            if (JosmPreferencesCredentialAgent.class.equals(credManager.getCredentialsAgentClass())) {
                if (OsmApi.isUsingOAuth()) {
                    return credManager.lookupOAuthAccessToken() != null;
                }
                String username = Main.pref.get("osm-server.username", null);
                String password = Main.pref.get("osm-server.password", null);
                return username != null && !username.isEmpty() && password != null && !password.isEmpty();
            }
            CredentialsAgentResponse credentials = credManager.getCredentials(Authenticator.RequestorType.SERVER, OsmApi.getOsmApi().getHost(), false);
            if (credentials != null) {
                String username = credentials.getUsername();
                char[] password = credentials.getPassword();
                return username != null && !username.isEmpty() && password != null && password.length > 0;
            }
        }
        catch (CredentialsAgentException e) {
            Main.warn("Unable to get credentials: " + e.getMessage());
        }
        return false;
    }

    private static class Worker
    implements Runnable {
        private int lastUnreadCount = 0;

        private Worker() {
        }

        @Override
        public void run() {
            try {
                final UserInfo userInfo = new OsmServerUserInfoReader().fetchUserInfo(NullProgressMonitor.INSTANCE, I18n.tr("get number of unread messages", new Object[0]));
                final int unread = userInfo.getUnreadMessages();
                if (unread > 0 && unread != this.lastUnreadCount) {
                    GuiHelper.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            JPanel panel = new JPanel(new GridBagLayout());
                            panel.add((Component)new JLabel(I18n.trn("You have {0} unread message.", "You have {0} unread messages.", unread, unread)), GBC.eol());
                            panel.add((Component)new UrlLabel(Main.getBaseUserUrl() + "/" + userInfo.getDisplayName() + "/inbox", I18n.tr("Click here to see your inbox.", new Object[0])), GBC.eol());
                            panel.setOpaque(false);
                            new Notification().setContent(panel).setIcon(1).setDuration(Notification.TIME_LONG).show();
                        }
                    });
                    this.lastUnreadCount = unread;
                }
            }
            catch (OsmTransferException e) {
                Main.warn(e);
            }
        }
    }
}

