/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.Reader;
import org.openstreetmap.josm.Main;

public class InvalidXmlCharacterFilter
extends Reader {
    private Reader reader;
    public static boolean firstWarning = true;
    public static final boolean[] INVALID_CHARS = new boolean[32];

    public InvalidXmlCharacterFilter(Reader reader) {
        this.reader = reader;
    }

    @Override
    public int read(char[] b, int off, int len) throws IOException {
        int n = this.reader.read(b, off, len);
        if (n == -1) {
            return -1;
        }
        for (int i = off; i < off + n; ++i) {
            b[i] = this.filter(b[i]);
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private char filter(char in) {
        if (in < ' ' && in >= '\u0000' && INVALID_CHARS[in]) {
            if (firstWarning) {
                Main.warn("Invalid xml character encountered: '" + in + "'.");
                firstWarning = false;
            }
            return ' ';
        }
        return in;
    }

    static {
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            InvalidXmlCharacterFilter.INVALID_CHARS[i] = true;
        }
        InvalidXmlCharacterFilter.INVALID_CHARS[9] = false;
        InvalidXmlCharacterFilter.INVALID_CHARS[10] = false;
        InvalidXmlCharacterFilter.INVALID_CHARS[13] = false;
    }
}

