/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class GpxImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("gpx,gpx.gz,gpx.bz2", "gpx", I18n.tr("GPX Files", new Object[0]) + " (*.gpx *.gpx.gz, *.gpx.bz2)");

    public GpxImporter() {
        super(FILE_FILTER);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        String fileName = file.getName();
        try (InputStream is = Compression.getUncompressedFileInputStream(file);){
            GpxReader r = new GpxReader(is);
            boolean parsedProperly = r.parse(true);
            r.getGpxData().storageFile = file;
            GpxImporter.addLayers(GpxImporter.loadLayers(r.getGpxData(), parsedProperly, fileName, I18n.tr("Markers from {0}", fileName)));
        }
        catch (SAXException e) {
            Main.error(e);
            throw new IOException(I18n.tr("Parsing data for layer ''{0}'' failed", fileName), e);
        }
    }

    public static void addLayers(final GpxImporterData data) {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (data.markerLayer != null) {
                    Main.main.addLayer(data.markerLayer);
                }
                if (data.gpxLayer != null) {
                    Main.main.addLayer(data.gpxLayer);
                }
                data.postLayerTask.run();
            }
        });
    }

    public static GpxImporterData loadLayers(final GpxData data, final boolean parsedProperly, final String gpxLayerName, String markerLayerName) {
        GpxLayer gpxLayer = null;
        MarkerLayer markerLayer = null;
        if (data.hasRoutePoints() || data.hasTrackPoints()) {
            gpxLayer = new GpxLayer(data, gpxLayerName, data.storageFile != null);
        }
        if (Main.pref.getBoolean("marker.makeautomarkers", true) && !data.waypoints.isEmpty()) {
            markerLayer = new MarkerLayer(data, markerLayerName, data.storageFile, gpxLayer);
            if (markerLayer.data.isEmpty()) {
                markerLayer = null;
            }
        }
        Runnable postLayerTask = new Runnable(){

            @Override
            public void run() {
                if (!parsedProperly) {
                    String msg = data.storageFile == null ? I18n.tr("Error occurred while parsing gpx data for layer ''{0}''. Only a part of the file will be available.", gpxLayerName) : I18n.tr("Error occurred while parsing gpx file ''{0}''. Only a part of the file will be available.", data.storageFile.getPath());
                    JOptionPane.showMessageDialog(null, msg);
                }
            }
        };
        return new GpxImporterData(gpxLayer, markerLayer, postLayerTask);
    }

    public static GpxImporterData loadLayers(InputStream is, File associatedFile, String gpxLayerName, String markerLayerName, ProgressMonitor progressMonitor) throws IOException {
        try {
            GpxReader r = new GpxReader(is);
            boolean parsedProperly = r.parse(true);
            r.getGpxData().storageFile = associatedFile;
            return GpxImporter.loadLayers(r.getGpxData(), parsedProperly, gpxLayerName, markerLayerName);
        }
        catch (SAXException e) {
            Main.error(e);
            throw new IOException(I18n.tr("Parsing data for layer ''{0}'' failed", gpxLayerName), e);
        }
    }

    public static class GpxImporterData {
        private GpxLayer gpxLayer;
        private MarkerLayer markerLayer;
        private Runnable postLayerTask;

        public GpxImporterData(GpxLayer gpxLayer, MarkerLayer markerLayer, Runnable postLayerTask) {
            this.gpxLayer = gpxLayer;
            this.markerLayer = markerLayer;
            this.postLayerTask = postLayerTask;
        }

        public GpxLayer getGpxLayer() {
            return this.gpxLayer;
        }

        public MarkerLayer getMarkerLayer() {
            return this.markerLayer;
        }

        public Runnable getPostLayerTask() {
            return this.postLayerTask;
        }
    }
}

