/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.GpxImporter;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class GpxExporter
extends FileExporter
implements GpxConstants {
    private static final String GPL_WARNING = "<html><font color='red' size='-2'>" + I18n.tr("Note: GPL is not compatible with the OSM license. Do not upload GPL licensed tracks.", new Object[0]) + "</html>";

    public GpxExporter() {
        super(GpxImporter.FILE_FILTER);
    }

    @Override
    public boolean acceptFile(File pathname, Layer layer) {
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            return false;
        }
        return super.acceptFile(pathname, layer);
    }

    @Override
    public void exportData(File file, Layer layer) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            throw new IllegalArgumentException(MessageFormat.format("Expected instance of OsmDataLayer or GpxLayer. Got ''{0}''.", layer.getClass().getName()));
        }
        CheckParameterUtil.ensureParameterNotNull(file, "file");
        String fn = file.getPath();
        if (fn.indexOf(46) == -1) {
            fn = fn + ".gpx";
            file = new File(fn);
        }
        JPanel p = new JPanel(new GridBagLayout());
        GpxData gpxData = layer instanceof GpxLayer ? ((GpxLayer)layer).data : new GpxData();
        p.add((Component)new JLabel(I18n.tr("GPS track description", new Object[0])), GBC.eol());
        JosmTextArea desc = new JosmTextArea(3, 40);
        desc.setWrapStyleWord(true);
        desc.setLineWrap(true);
        desc.setText(gpxData.getString("meta.desc"));
        p.add((Component)new JScrollPane(desc), GBC.eop().fill(1));
        JCheckBox author = new JCheckBox(I18n.tr("Add author information", new Object[0]), Main.pref.getBoolean("lastAddAuthor", true));
        p.add((Component)author, GBC.eol());
        JLabel nameLabel = new JLabel(I18n.tr("Real name", new Object[0]));
        p.add((Component)nameLabel, GBC.std().insets(10, 0, 5, 0));
        JosmTextField authorName = new JosmTextField();
        p.add((Component)authorName, GBC.eol().fill(2));
        JLabel emailLabel = new JLabel(I18n.tr("E-Mail", new Object[0]));
        p.add((Component)emailLabel, GBC.std().insets(10, 0, 5, 0));
        JosmTextField email = new JosmTextField();
        p.add((Component)email, GBC.eol().fill(2));
        JLabel copyrightLabel = new JLabel(I18n.tr("Copyright (URL)", new Object[0]));
        p.add((Component)copyrightLabel, GBC.std().insets(10, 0, 5, 0));
        JosmTextField copyright = new JosmTextField();
        p.add((Component)copyright, GBC.std().fill(2));
        JButton predefined = new JButton(I18n.tr("Predefined", new Object[0]));
        p.add((Component)predefined, GBC.eol().insets(5, 0, 0, 0));
        JLabel copyrightYearLabel = new JLabel(I18n.tr("Copyright year", new Object[0]));
        p.add((Component)copyrightYearLabel, GBC.std().insets(10, 0, 5, 5));
        JosmTextField copyrightYear = new JosmTextField("");
        p.add((Component)copyrightYear, GBC.eol().fill(2));
        JLabel warning = new JLabel("<html><font size='-2'>&nbsp;</html");
        p.add((Component)warning, GBC.eol().fill(2).insets(15, 0, 0, 0));
        GpxExporter.addDependencies(gpxData, author, authorName, email, copyright, predefined, copyrightYear, nameLabel, emailLabel, copyrightLabel, copyrightYearLabel, warning);
        p.add((Component)new JLabel(I18n.tr("Keywords", new Object[0])), GBC.eol());
        JosmTextField keywords = new JosmTextField();
        keywords.setText(gpxData.getString("meta.keywords"));
        p.add((Component)keywords, GBC.eop().fill(2));
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Export options", new Object[0]), new String[]{I18n.tr("Export and Save", new Object[0]), I18n.tr("Cancel", new Object[0])});
        ed.setButtonIcons(new String[]{"exportgpx", "cancel"});
        ed.setContent(p);
        ed.showDialog();
        if (ed.getValue() != 1) {
            this.setCanceled(true);
            return;
        }
        this.setCanceled(false);
        Main.pref.put("lastAddAuthor", author.isSelected());
        if (authorName.getText().length() != 0) {
            Main.pref.put("lastAuthorName", authorName.getText());
        }
        if (copyright.getText().length() != 0) {
            Main.pref.put("lastCopyright", copyright.getText());
        }
        gpxData = layer instanceof OsmDataLayer ? ((OsmDataLayer)layer).toGpxData() : (layer instanceof GpxLayer ? ((GpxLayer)layer).data : OsmDataLayer.toGpxData(this.getCurrentDataSet(), file));
        if (author.isSelected()) {
            if (authorName.getText().length() > 0) {
                gpxData.put("meta.author.name", authorName.getText());
                gpxData.put("meta.copyright.author", authorName.getText());
            }
            if (email.getText().length() > 0) {
                gpxData.put("meta.author.email", email.getText());
            }
            if (copyright.getText().length() > 0) {
                gpxData.put("meta.copyright.license", copyright.getText());
            }
            if (copyrightYear.getText().length() > 0) {
                gpxData.put("meta.copyright.year", copyrightYear.getText());
            }
        }
        if (desc.getText().length() > 0) {
            gpxData.put("meta.desc", desc.getText());
        }
        if (keywords.getText().length() > 0) {
            gpxData.put("meta.keywords", keywords.getText());
        }
        try (OutputStream fo = Compression.getCompressedFileOutputStream(file);){
            new GpxWriter(fo).write(gpxData);
            fo.flush();
        }
        catch (IOException x) {
            Main.error(x);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while exporting {0}:\n{1}", fn, x.getMessage()), I18n.tr("Error", new Object[0]), 0);
        }
    }

    private static void enableCopyright(GpxData data, JosmTextField copyright, JButton predefined, JosmTextField copyrightYear, JLabel copyrightLabel, JLabel copyrightYearLabel, JLabel warning, boolean enable) {
        copyright.setEnabled(enable);
        predefined.setEnabled(enable);
        copyrightYear.setEnabled(enable);
        copyrightLabel.setEnabled(enable);
        copyrightYearLabel.setEnabled(enable);
        warning.setText(enable ? GPL_WARNING : "<html><font size='-2'>&nbsp;</html");
        if (enable) {
            if (copyrightYear.getText().isEmpty()) {
                String sCopyrightYear = data.getString("meta.copyright.year");
                if (sCopyrightYear == null) {
                    sCopyrightYear = Integer.toString(Calendar.getInstance().get(1));
                }
                copyrightYear.setText(sCopyrightYear);
            }
            if (copyright.getText().isEmpty()) {
                String sCopyright = data.getString("meta.copyright.license");
                if (sCopyright == null) {
                    sCopyright = Main.pref.get("lastCopyright", "https://creativecommons.org/licenses/by-sa/2.5");
                }
                copyright.setText(sCopyright);
                copyright.setCaretPosition(0);
            }
        } else {
            copyrightYear.setText("");
            copyright.setText("");
        }
    }

    private static void addDependencies(final GpxData data, final JCheckBox author, final JosmTextField authorName, final JosmTextField email, final JosmTextField copyright, final JButton predefined, final JosmTextField copyrightYear, final JLabel nameLabel, final JLabel emailLabel, final JLabel copyrightLabel, final JLabel copyrightYearLabel, final JLabel warning) {
        ActionListener authorActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = author.isSelected();
                authorName.setEnabled(b);
                email.setEnabled(b);
                nameLabel.setEnabled(b);
                emailLabel.setEnabled(b);
                if (b) {
                    String sAuthorName = data.getString("meta.author.name");
                    if (sAuthorName == null) {
                        sAuthorName = Main.pref.get("lastAuthorName");
                    }
                    authorName.setText(sAuthorName);
                    String sEmail = data.getString("meta.author.email");
                    if (sEmail == null) {
                        sEmail = Main.pref.get("lastAuthorEmail");
                    }
                    email.setText(sEmail);
                } else {
                    authorName.setText("");
                    email.setText("");
                }
                boolean isAuthorSet = authorName.getText().length() != 0;
                GpxExporter.enableCopyright(data, copyright, predefined, copyrightYear, copyrightLabel, copyrightYearLabel, warning, b && isAuthorSet);
            }
        };
        author.addActionListener(authorActionListener);
        KeyAdapter authorNameListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                boolean b = authorName.getText().length() != 0 && author.isSelected();
                GpxExporter.enableCopyright(data, copyright, predefined, copyrightYear, copyrightLabel, copyrightYearLabel, warning, b);
            }
        };
        authorName.addKeyListener(authorNameListener);
        predefined.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] licenses = new String[]{"Creative Commons By-SA", "Open Database License (ODbL)", "public domain", "GNU Lesser Public License (LGPL)", "BSD License (MIT/X11)"};
                JList<String> l = new JList<String>(licenses);
                l.setVisibleRowCount(licenses.length);
                l.setSelectionMode(2);
                int answer = JOptionPane.showConfirmDialog(Main.parent, new JScrollPane(l), I18n.tr("Choose a predefined license", new Object[0]), 2, 3);
                if (answer != 0 || l.getSelectedIndex() == -1) {
                    return;
                }
                String[] urls = new String[]{"https://creativecommons.org/licenses/by-sa/3.0", "http://opendatacommons.org/licenses/odbl/1.0", "public domain", "https://www.gnu.org/copyleft/lesser.html", "http://www.opensource.org/licenses/bsd-license.php"};
                String license = "";
                for (int i : l.getSelectedIndices()) {
                    if (i == 2) {
                        license = "public domain";
                        break;
                    }
                    license = license + (license.isEmpty() ? urls[i] : ", " + urls[i]);
                }
                copyright.setText(license);
                copyright.setCaretPosition(0);
            }
        });
        authorActionListener.actionPerformed(null);
        authorNameListener.keyReleased(null);
    }

    private DataSet getCurrentDataSet() {
        return Main.main.getCurrentDataSet();
    }
}

