/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class GeoJSONWriter {
    private OsmDataLayer layer;

    public GeoJSONWriter(OsmDataLayer layer) {
        this.layer = layer;
    }

    public String write() {
        return this.write(true);
    }

    public String write(boolean pretty) {
        StringWriter stringWriter = new StringWriter();
        HashMap<String, Boolean> config = new HashMap<String, Boolean>(1);
        config.put("javax.json.stream.JsonGenerator.prettyPrinting", pretty);
        try (JsonWriter writer = Json.createWriterFactory(config).createWriter(stringWriter);){
            JsonObjectBuilder object = Json.createObjectBuilder().add("type", "FeatureCollection").add("generator", "JOSM");
            GeoJSONWriter.appendLayerBounds(this.layer.data, object);
            GeoJSONWriter.appendLayerFeatures(this.layer.data, object);
            writer.writeObject(object.build());
            String string = stringWriter.toString();
            return string;
        }
    }

    protected static void appendPrimitive(OsmPrimitive p, JsonArrayBuilder array) {
        if (p.isIncomplete()) {
            return;
        }
        if (p instanceof Node && p.getKeys().isEmpty()) {
            return;
        }
        JsonObjectBuilder propObj = Json.createObjectBuilder();
        for (Map.Entry<String, String> t : p.getKeys().entrySet()) {
            propObj.add(t.getKey(), t.getValue());
        }
        JsonObjectBuilder geomObj = Json.createObjectBuilder();
        p.accept(new GeometryPrimitiveVisitor(geomObj));
        array.add(Json.createObjectBuilder().add("type", "Feature").add("properties", propObj).add("geometry", geomObj));
    }

    protected static void appendLayerBounds(DataSet ds, JsonObjectBuilder object) {
        Iterator<Bounds> it;
        if (ds != null && (it = ds.getDataSourceBounds().iterator()).hasNext()) {
            Bounds b = new Bounds(it.next());
            while (it.hasNext()) {
                b.extend(it.next());
            }
            GeoJSONWriter.appendBounds(b, object);
        }
    }

    protected static void appendBounds(Bounds b, JsonObjectBuilder object) {
        if (b != null) {
            object.add("bbox", Json.createArrayBuilder().add(b.getMinLon()).add(b.getMinLat()).add(b.getMaxLon()).add(b.getMaxLat()));
        }
    }

    protected static void appendLayerFeatures(DataSet ds, JsonObjectBuilder object) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        if (ds != null) {
            for (Node n : ds.getNodes()) {
                GeoJSONWriter.appendPrimitive(n, array);
            }
            for (Way w : ds.getWays()) {
                GeoJSONWriter.appendPrimitive(w, array);
            }
        }
        object.add("features", array);
    }

    private static class GeometryPrimitiveVisitor
    implements PrimitiveVisitor {
        private final JsonObjectBuilder geomObj;

        public GeometryPrimitiveVisitor(JsonObjectBuilder geomObj) {
            this.geomObj = geomObj;
        }

        @Override
        public void visit(INode n) {
            this.geomObj.add("type", "Point");
            LatLon ll = n.getCoor();
            if (ll != null) {
                this.geomObj.add("coordinates", this.getCoorArray(n.getCoor()));
            }
        }

        @Override
        public void visit(IWay w) {
            this.geomObj.add("type", "LineString");
            if (w instanceof Way) {
                JsonArrayBuilder array = Json.createArrayBuilder();
                for (Node n : ((Way)w).getNodes()) {
                    LatLon ll = n.getCoor();
                    if (ll == null) continue;
                    array.add(this.getCoorArray(ll));
                }
                this.geomObj.add("coordinates", array);
            }
        }

        @Override
        public void visit(IRelation r) {
        }

        private JsonArrayBuilder getCoorArray(LatLon c) {
            return Json.createArrayBuilder().add(c.lon()).add(c.lat());
        }
    }
}

