/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class FileWatcher {
    private WatchService watcher;
    private final Map<Path, StyleSource> styleMap = new HashMap<Path, StyleSource>();
    private final Map<Path, SourceEntry> ruleMap = new HashMap<Path, SourceEntry>();

    public FileWatcher() {
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    FileWatcher.this.processEvents();
                }
            }, "File Watcher").start();
        }
        catch (IOException e) {
            Main.error(e);
        }
    }

    public void registerStyleSource(StyleSource style) throws IOException {
        this.register(style, this.styleMap);
    }

    public void registerValidatorRule(SourceEntry rule) throws IOException {
        this.register(rule, this.ruleMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends SourceEntry> void register(T obj, Map<Path, T> map) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(obj, "obj");
        if (this.watcher == null) {
            throw new IllegalStateException("File watcher is not available");
        }
        File file = new File(obj.url);
        File dir = file.getParentFile();
        if (dir == null) {
            throw new IllegalArgumentException("Resource " + obj + " does not have a parent directory");
        }
        FileWatcher fileWatcher = this;
        synchronized (fileWatcher) {
            dir.toPath().register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
            map.put(file.toPath(), obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvents() {
        WatchKey key;
        if (Main.isDebugEnabled()) {
            Main.debug("File watcher thread started");
        }
        do {
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent<?> ev;
                Path filename;
                WatchEvent.Kind<?> kind = event.kind();
                if (StandardWatchEventKinds.OVERFLOW.equals(kind) || (filename = (Path)(ev = event).context()) == null) continue;
                Path fullPath = ((Path)key.watchable()).resolve(filename);
                FileWatcher fileWatcher = this;
                synchronized (fileWatcher) {
                    StyleSource style = this.styleMap.get(fullPath);
                    SourceEntry rule = this.ruleMap.get(fullPath);
                    if (style != null) {
                        Main.info("Map style " + style.getDisplayString() + " has been modified. Reloading style...");
                        Main.worker.submit(new MapPaintStyles.MapPaintStyleLoader(Collections.singleton(style)));
                    } else if (rule != null) {
                        Main.info("Validator rule " + rule.getDisplayString() + " has been modified. Reloading rule...");
                        MapCSSTagChecker tagChecker = OsmValidator.getTest(MapCSSTagChecker.class);
                        if (tagChecker != null) {
                            try {
                                tagChecker.addMapCSS(rule.url);
                            }
                            catch (IOException | ParseException e) {
                                Main.warn(e);
                            }
                        }
                    } else if (Main.isDebugEnabled()) {
                        Main.debug("Received " + kind.name() + " event for unregistered file: " + fullPath);
                    }
                }
            }
        } while (key.reset());
    }
}

