/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.ImportCancelException;
import org.openstreetmap.josm.tools.I18n;

public abstract class FileImporter
implements Comparable<FileImporter>,
MapView.LayerChangeListener {
    public final ExtensionFileFilter filter;
    private boolean enabled;

    public FileImporter(ExtensionFileFilter filter) {
        this.filter = filter;
        this.enabled = true;
    }

    public boolean acceptFile(File pathname) {
        return this.filter.acceptName(pathname.getName());
    }

    public boolean isBatchImporter() {
        return false;
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        throw new IOException(I18n.tr("Could not import ''{0}''.", file.getName()));
    }

    public void importData(List<File> files, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        throw new IOException(I18n.tr("Could not import files.", new Object[0]));
    }

    public boolean importDataHandleExceptions(File f, ProgressMonitor progressMonitor) {
        try {
            Main.info("Open file: " + f.getAbsolutePath() + " (" + f.length() + " bytes)");
            this.importData(f, progressMonitor);
            return true;
        }
        catch (IllegalDataException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ImportCancelException) {
                FileImporter.displayCancel(cause);
            } else {
                FileImporter.displayError(f, e);
            }
            return false;
        }
        catch (Exception e) {
            FileImporter.displayError(f, e);
            return false;
        }
    }

    private static void displayError(File f, Exception e) {
        Main.error(e);
        HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not read file ''{0}''.<br>Error is:<br>{1}</html>", f.getName(), e.getMessage()), I18n.tr("Error", new Object[0]), 0, null);
    }

    private static void displayCancel(final Throwable t) {
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                Notification note = new Notification(t.getMessage());
                note.setIcon(1);
                note.setDuration(Notification.TIME_SHORT);
                note.show();
            }
        });
    }

    public boolean importDataHandleExceptions(List<File> files, ProgressMonitor progressMonitor) {
        try {
            Main.info("Open " + files.size() + " files");
            this.importData(files, progressMonitor);
            return true;
        }
        catch (Exception e) {
            Main.error(e);
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not read files.<br>Error is:<br>{0}</html>", e.getMessage()), I18n.tr("Error", new Object[0]), 0, null);
            return false;
        }
    }

    public double getPriority() {
        return 0.0;
    }

    @Override
    public int compareTo(FileImporter other) {
        return Double.compare(this.getPriority(), other.getPriority());
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
    }
}

