/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;

public abstract class FileExporter
implements MapView.LayerChangeListener {
    public final ExtensionFileFilter filter;
    private boolean enabled;
    private boolean canceled;

    public FileExporter(ExtensionFileFilter filter) {
        this.filter = filter;
        this.enabled = true;
    }

    public boolean acceptFile(File pathname, Layer layer) {
        return this.filter.acceptName(pathname.getName());
    }

    public void exportData(File file, Layer layer) throws IOException {
        throw new IOException(I18n.tr("Could not export ''{0}''.", file.getName()));
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
    }

    public final boolean isCanceled() {
        return this.canceled;
    }

    public final void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }
}

