/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferencesPanel;
import org.openstreetmap.josm.tools.I18n;

public class DefaultProxySelector
extends ProxySelector {
    private static final List<Proxy> NO_PROXY_LIST = Collections.singletonList(Proxy.NO_PROXY);
    private static boolean JVM_WILL_USE_SYSTEM_PROXIES = false;
    private ProxyPreferencesPanel.ProxyPolicy proxyPolicy;
    private InetSocketAddress httpProxySocketAddress;
    private InetSocketAddress socksProxySocketAddress;
    private ProxySelector delegate;
    private final Set<String> errorResources = new HashSet<String>();
    private final Set<String> errorMessages = new HashSet<String>();
    private Set<String> proxyExceptions;

    public static boolean willJvmRetrieveSystemProxies() {
        return JVM_WILL_USE_SYSTEM_PROXIES;
    }

    public DefaultProxySelector(ProxySelector delegate) {
        this.delegate = delegate;
        this.initFromPreferences();
    }

    protected int parseProxyPortValue(String property, String value) {
        if (value == null) {
            return 0;
        }
        int port = 0;
        try {
            port = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Main.error(I18n.tr("Unexpected format for port number in preference ''{0}''. Got ''{1}''.", property, value));
            Main.error(I18n.tr("The proxy will not be used.", new Object[0]));
            return 0;
        }
        if (port <= 0 || port > 65535) {
            Main.error(I18n.tr("Illegal port number in preference ''{0}''. Got {1}.", property, port));
            Main.error(I18n.tr("The proxy will not be used.", new Object[0]));
            return 0;
        }
        return port;
    }

    public final void initFromPreferences() {
        String value = Main.pref.get("proxy.policy");
        if (value.length() == 0) {
            this.proxyPolicy = ProxyPreferencesPanel.ProxyPolicy.NO_PROXY;
        } else {
            this.proxyPolicy = ProxyPreferencesPanel.ProxyPolicy.fromName(value);
            if (this.proxyPolicy == null) {
                Main.warn(I18n.tr("Unexpected value for preference ''{0}'' found. Got ''{1}''. Will use no proxy.", "proxy.policy", value));
                this.proxyPolicy = ProxyPreferencesPanel.ProxyPolicy.NO_PROXY;
            }
        }
        String host = Main.pref.get("proxy.http.host", null);
        int port = this.parseProxyPortValue("proxy.http.port", Main.pref.get("proxy.http.port", null));
        this.httpProxySocketAddress = null;
        if (this.proxyPolicy.equals((Object)ProxyPreferencesPanel.ProxyPolicy.USE_HTTP_PROXY)) {
            if (host != null && !host.trim().isEmpty() && port > 0) {
                this.httpProxySocketAddress = new InetSocketAddress(host, port);
            } else {
                Main.warn(I18n.tr("Unexpected parameters for HTTP proxy. Got host ''{0}'' and port ''{1}''.", host, port));
                Main.warn(I18n.tr("The proxy will not be used.", new Object[0]));
            }
        }
        host = Main.pref.get("proxy.socks.host", null);
        port = this.parseProxyPortValue("proxy.socks.port", Main.pref.get("proxy.socks.port", null));
        this.socksProxySocketAddress = null;
        if (this.proxyPolicy.equals((Object)ProxyPreferencesPanel.ProxyPolicy.USE_SOCKS_PROXY)) {
            if (host != null && !host.trim().isEmpty() && port > 0) {
                this.socksProxySocketAddress = new InetSocketAddress(host, port);
            } else {
                Main.warn(I18n.tr("Unexpected parameters for SOCKS proxy. Got host ''{0}'' and port ''{1}''.", host, port));
                Main.warn(I18n.tr("The proxy will not be used.", new Object[0]));
            }
        }
        this.proxyExceptions = new HashSet<String>(Main.pref.getCollection("proxy.exceptions", Arrays.asList("localhost", "127.0.0.1", "::1")));
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        Main.error(I18n.tr("Connection to proxy ''{0}'' for URI ''{1}'' failed. Exception was: {2}", sa.toString(), uri.toString(), ioe.toString()));
        this.errorResources.add(uri.toString());
        this.errorMessages.add(ioe.toString());
    }

    public final Set<String> getErrorResources() {
        return new TreeSet<String>(this.errorResources);
    }

    public final Set<String> getErrorMessages() {
        return new TreeSet<String>(this.errorMessages);
    }

    public final void clearErrors() {
        this.errorResources.clear();
        this.errorMessages.clear();
    }

    public final boolean hasErrors() {
        return !this.errorResources.isEmpty();
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri != null && this.proxyExceptions.contains(uri.getHost())) {
            return NO_PROXY_LIST;
        }
        switch (this.proxyPolicy) {
            case USE_SYSTEM_SETTINGS: {
                if (!JVM_WILL_USE_SYSTEM_PROXIES) {
                    Main.warn(I18n.tr("The JVM is not configured to lookup proxies from the system settings. The property ''java.net.useSystemProxies'' was missing at startup time.  Will not use a proxy.", new Object[0]));
                    return NO_PROXY_LIST;
                }
                return this.delegate.select(uri);
            }
            case NO_PROXY: {
                return NO_PROXY_LIST;
            }
            case USE_HTTP_PROXY: {
                if (this.httpProxySocketAddress == null) {
                    return NO_PROXY_LIST;
                }
                return Collections.singletonList(new Proxy(Proxy.Type.HTTP, this.httpProxySocketAddress));
            }
            case USE_SOCKS_PROXY: {
                if (this.socksProxySocketAddress == null) {
                    return NO_PROXY_LIST;
                }
                return Collections.singletonList(new Proxy(Proxy.Type.SOCKS, this.socksProxySocketAddress));
            }
        }
        return null;
    }

    static {
        String v = System.getProperty("java.net.useSystemProxies");
        if (v != null && v.equals(Boolean.TRUE.toString())) {
            JVM_WILL_USE_SYSTEM_PROXIES = true;
        }
    }
}

