/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.openstreetmap.josm.tools.Utils;

public enum Compression {
    NONE,
    BZIP2,
    GZIP,
    ZIP;


    public static Compression byExtension(String name) {
        return name != null && name.endsWith(".gz") ? GZIP : (name != null && (name.endsWith(".bz2") || name.endsWith(".bz")) ? BZIP2 : (name != null && name.endsWith(".zip") ? ZIP : NONE));
    }

    public InputStream getUncompressedInputStream(InputStream in) throws IOException {
        switch (this) {
            case BZIP2: {
                return Utils.getBZip2InputStream(in);
            }
            case GZIP: {
                return Utils.getGZipInputStream(in);
            }
            case ZIP: {
                return Utils.getZipInputStream(in);
            }
        }
        return in;
    }

    public static InputStream getUncompressedFileInputStream(File file) throws IOException {
        return Compression.byExtension(file.getName()).getUncompressedInputStream(new FileInputStream(file));
    }

    public static InputStream getUncompressedURLInputStream(URL url) throws IOException {
        return Utils.openURLAndDecompress(url, true);
    }

    public OutputStream getCompressedOutputStream(OutputStream out) throws IOException {
        switch (this) {
            case BZIP2: {
                return new BZip2CompressorOutputStream(out);
            }
            case GZIP: {
                return new GZIPOutputStream(out);
            }
            case ZIP: {
                return new ZipOutputStream(out, StandardCharsets.UTF_8);
            }
        }
        return out;
    }

    public static OutputStream getCompressedFileOutputStream(File file) throws IOException {
        return Compression.byExtension(file.getName()).getCompressedOutputStream(new FileOutputStream(file));
    }
}

