/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ChangesetQuery {
    private Integer uid = null;
    private String userName = null;
    private Bounds bounds = null;
    private Date closedAfter = null;
    private Date createdBefore = null;
    private Boolean open = null;
    private Boolean closed = null;
    private Collection<Long> changesetIds = null;

    public static ChangesetQuery buildFromUrlQuery(String query) throws ChangesetQueryUrlException {
        return new ChangesetQueryUrlParser().parse(query);
    }

    public ChangesetQuery forUser(int uid) throws IllegalArgumentException {
        if (uid <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "uid", uid));
        }
        this.uid = uid;
        this.userName = null;
        return this;
    }

    public ChangesetQuery forUser(String username) {
        CheckParameterUtil.ensureParameterNotNull(username, "username");
        this.userName = username;
        this.uid = null;
        return this;
    }

    public boolean isRestrictedToPartiallyIdentifiedUser() {
        return this.userName != null;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isRestrictedToFullyIdentifiedUser() {
        return this.uid > 0;
    }

    public ChangesetQuery inBbox(double minLon, double minLat, double maxLon, double maxLat) throws IllegalArgumentException {
        if (!LatLon.isValidLon(minLon)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "minLon", minLon));
        }
        if (!LatLon.isValidLon(maxLon)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "maxLon", maxLon));
        }
        if (!LatLon.isValidLat(minLat)) {
            throw new IllegalArgumentException(I18n.tr("Illegal latitude value for parameter ''{0}'', got {1}", "minLat", minLat));
        }
        if (!LatLon.isValidLat(maxLat)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "maxLat", maxLat));
        }
        return this.inBbox(new LatLon(minLon, minLat), new LatLon(maxLon, maxLat));
    }

    public ChangesetQuery inBbox(LatLon min, LatLon max) {
        CheckParameterUtil.ensureParameterNotNull(min, "min");
        CheckParameterUtil.ensureParameterNotNull(max, "max");
        this.bounds = new Bounds(min, max);
        return this;
    }

    public ChangesetQuery inBbox(Bounds bbox) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(bbox, "bbox");
        this.bounds = bbox;
        return this;
    }

    public ChangesetQuery closedAfter(Date d) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(d, "d");
        this.closedAfter = d;
        return this;
    }

    public ChangesetQuery closedAfterAndCreatedBefore(Date closedAfter, Date createdBefore) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(closedAfter, "closedAfter");
        CheckParameterUtil.ensureParameterNotNull(createdBefore, "createdBefore");
        this.closedAfter = closedAfter;
        this.createdBefore = createdBefore;
        return this;
    }

    public ChangesetQuery beingOpen(boolean isOpen) {
        this.open = isOpen;
        return this;
    }

    public ChangesetQuery beingClosed(boolean isClosed) {
        this.closed = isClosed;
        return this;
    }

    public ChangesetQuery forChangesetIds(Collection<Long> changesetIds) {
        CheckParameterUtil.ensureParameterNotNull(changesetIds, "changesetIds");
        this.changesetIds = changesetIds;
        return this;
    }

    public String getQueryString() {
        StringBuilder sb = new StringBuilder();
        if (this.uid != null) {
            sb.append("user").append("=").append(this.uid);
        } else if (this.userName != null) {
            try {
                sb.append("display_name").append("=").append(URLEncoder.encode(this.userName, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Main.error(e);
            }
        }
        if (this.bounds != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("bbox=").append(this.bounds.encodeAsString(","));
        }
        if (this.closedAfter != null && this.createdBefore != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            SimpleDateFormat df = DateUtils.newIsoDateTimeFormat();
            sb.append("time").append("=").append(df.format(this.closedAfter));
            sb.append(",").append(df.format(this.createdBefore));
        } else if (this.closedAfter != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            SimpleDateFormat df = DateUtils.newIsoDateTimeFormat();
            sb.append("time").append("=").append(df.format(this.closedAfter));
        }
        if (this.open != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("open=").append(Boolean.toString(this.open));
        } else if (this.closed != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("closed=").append(Boolean.toString(this.closed));
        } else if (this.changesetIds != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("changesets=").append(Utils.join(",", this.changesetIds));
        }
        return sb.toString();
    }

    public String toString() {
        return this.getQueryString();
    }

    public static class ChangesetQueryUrlParser {
        protected int parseUid(String value) throws ChangesetQueryUrlException {
            int id;
            if (value == null || value.trim().isEmpty()) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", value));
            }
            try {
                id = Integer.parseInt(value);
                if (id <= 0) {
                    throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", value));
                }
            }
            catch (NumberFormatException e) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", value));
            }
            return id;
        }

        protected boolean parseBoolean(String value, String parameter) throws ChangesetQueryUrlException {
            if (value == null || value.trim().isEmpty()) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", parameter, value));
            }
            switch (value) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", parameter, value));
        }

        protected Date parseDate(String value, String parameter) throws ChangesetQueryUrlException {
            if (value == null || value.trim().isEmpty()) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", parameter, value));
            }
            SimpleDateFormat formatter = DateUtils.newIsoDateTimeFormat();
            try {
                return formatter.parse(value);
            }
            catch (ParseException e) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", parameter, value));
            }
        }

        protected Date[] parseTime(String value) throws ChangesetQueryUrlException {
            String[] dates = value.split(",");
            if (dates == null || dates.length == 0 || dates.length > 2) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "time", value));
            }
            if (dates.length == 1) {
                return new Date[]{this.parseDate(dates[0], "time")};
            }
            if (dates.length == 2) {
                return new Date[]{this.parseDate(dates[0], "time"), this.parseDate(dates[1], "time")};
            }
            return null;
        }

        protected Collection<Long> parseLongs(String value) {
            return value == null || value.isEmpty() ? Collections.emptySet() : new HashSet<Long>(Utils.transform(Arrays.asList(value.split(",")), new Utils.Function<String, Long>(){

                @Override
                public Long apply(String x) {
                    return Long.valueOf(x);
                }
            }));
        }

        protected ChangesetQuery createFromMap(Map<String, String> queryParams) throws ChangesetQueryUrlException {
            ChangesetQuery csQuery = new ChangesetQuery();
            block26: for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                String k;
                switch (k = entry.getKey()) {
                    case "uid": {
                        if (queryParams.containsKey("display_name")) {
                            throw new ChangesetQueryUrlException(I18n.tr("Cannot create a changeset query including both the query parameters ''uid'' and ''display_name''", new Object[0]));
                        }
                        csQuery.forUser(this.parseUid(queryParams.get("uid")));
                        continue block26;
                    }
                    case "display_name": {
                        if (queryParams.containsKey("uid")) {
                            throw new ChangesetQueryUrlException(I18n.tr("Cannot create a changeset query including both the query parameters ''uid'' and ''display_name''", new Object[0]));
                        }
                        csQuery.forUser(queryParams.get("display_name"));
                        continue block26;
                    }
                    case "open": {
                        csQuery.beingOpen(this.parseBoolean(entry.getValue(), "open"));
                        continue block26;
                    }
                    case "closed": {
                        csQuery.beingClosed(this.parseBoolean(entry.getValue(), "closed"));
                        continue block26;
                    }
                    case "time": {
                        Date[] dates = this.parseTime(entry.getValue());
                        switch (dates.length) {
                            case 1: {
                                csQuery.closedAfter(dates[0]);
                                break;
                            }
                            case 2: {
                                csQuery.closedAfterAndCreatedBefore(dates[0], dates[1]);
                            }
                        }
                        continue block26;
                    }
                    case "bbox": {
                        try {
                            csQuery.inBbox(new Bounds(entry.getValue(), ","));
                            continue block26;
                        }
                        catch (IllegalArgumentException e) {
                            throw new ChangesetQueryUrlException(e);
                        }
                    }
                    case "changesets": {
                        try {
                            csQuery.forChangesetIds(this.parseLongs(entry.getValue()));
                            continue block26;
                        }
                        catch (NumberFormatException e) {
                            throw new ChangesetQueryUrlException(e);
                        }
                    }
                }
                throw new ChangesetQueryUrlException(I18n.tr("Unsupported parameter ''{0}'' in changeset query string", k));
            }
            return csQuery;
        }

        protected Map<String, String> createMapFromQueryString(String query) {
            String[] keyValuePairs;
            HashMap<String, String> queryParams = new HashMap<String, String>();
            for (String keyValuePair : keyValuePairs = query.split("&")) {
                String[] kv = keyValuePair.split("=");
                queryParams.put(kv[0], kv.length > 1 ? kv[1] : "");
            }
            return queryParams;
        }

        public ChangesetQuery parse(String query) throws ChangesetQueryUrlException {
            if (query == null) {
                return new ChangesetQuery();
            }
            if ((query = query.trim()).isEmpty()) {
                return new ChangesetQuery();
            }
            Map<String, String> queryParams = this.createMapFromQueryString(query);
            return this.createFromMap(queryParams);
        }
    }

    public static class ChangesetQueryUrlException
    extends Exception {
        public ChangesetQueryUrlException(String message) {
            super(message);
        }

        public ChangesetQueryUrlException(Throwable cause) {
            super(cause);
        }
    }
}

