/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Capabilities {
    private final Map<String, HashMap<String, String>> capabilities = new HashMap<String, HashMap<String, String>>();
    private final List<String> imageryBlacklist = new ArrayList<String>();

    public boolean isDefined(String element, String attribute) {
        if (!this.capabilities.containsKey(element)) {
            return false;
        }
        HashMap<String, String> e = this.capabilities.get(element);
        if (e == null) {
            return false;
        }
        return e.get(attribute) != null;
    }

    public String get(String element, String attribute) {
        if (!this.capabilities.containsKey(element)) {
            return null;
        }
        HashMap<String, String> e = this.capabilities.get(element);
        if (e == null) {
            return null;
        }
        return e.get(attribute);
    }

    public Double getDouble(String element, String attribute) throws NumberFormatException {
        String s = this.get(element, attribute);
        if (s == null) {
            return null;
        }
        return Double.parseDouble(s);
    }

    public Long getLong(String element, String attribute) {
        String s = this.get(element, attribute);
        if (s == null) {
            return null;
        }
        return Long.parseLong(s);
    }

    public void put(String element, String attribute, String value) {
        if ("blacklist".equals(element)) {
            if ("regex".equals(attribute)) {
                this.imageryBlacklist.add(value);
            }
        } else {
            if (!this.capabilities.containsKey(element)) {
                HashMap h = new HashMap();
                this.capabilities.put(element, h);
            }
            HashMap<String, String> e = this.capabilities.get(element);
            e.put(attribute, value);
        }
    }

    public final void clear() {
        this.capabilities.clear();
        this.imageryBlacklist.clear();
    }

    public boolean supportsVersion(String version) {
        return this.get("version", "minimum").compareTo(version) <= 0 && this.get("version", "maximum").compareTo(version) >= 0;
    }

    private static void warnIllegalValue(String attr, String elem, Object val) {
        Main.warn(I18n.tr("Illegal value of attribute ''{0}'' of element ''{1}'' in server capabilities. Got ''{2}''", attr, elem, val));
    }

    public int getMaxChangesetSize() {
        String v = this.get("changesets", "maximum_elements");
        if (v != null) {
            try {
                int n = Integer.parseInt(v);
                if (n > 0) {
                    return n;
                }
                Capabilities.warnIllegalValue("changesets", "maximum_elements", n);
            }
            catch (NumberFormatException e) {
                Capabilities.warnIllegalValue("changesets", "maximum_elements", v);
            }
        }
        return -1;
    }

    public long getMaxWayNodes() {
        String v = this.get("waynodes", "maximum");
        if (v != null) {
            try {
                Long n = Long.parseLong(v);
                if (n > 0L) {
                    return n;
                }
                Capabilities.warnIllegalValue("waynodes", "maximum", n);
            }
            catch (NumberFormatException e) {
                Capabilities.warnIllegalValue("waynodes", "maximum", v);
            }
        }
        return -1L;
    }

    public boolean isOnImageryBlacklist(String url) {
        if (url != null && this.imageryBlacklist != null) {
            for (String blacklistRegex : this.imageryBlacklist) {
                if (!url.matches(blacklistRegex)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getImageryBlacklist() {
        return Collections.unmodifiableList(this.imageryBlacklist);
    }

    public static final class CapabilitiesParser
    extends DefaultHandler {
        private Capabilities capabilities;

        @Override
        public void startDocument() throws SAXException {
            this.capabilities = new Capabilities();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            for (int i = 0; i < atts.getLength(); ++i) {
                this.capabilities.put(qName, atts.getQName(i), atts.getValue(i));
            }
        }

        public Capabilities getCapabilities() {
            return this.capabilities;
        }

        public static Capabilities parse(InputSource inputSource) throws SAXException, IOException, ParserConfigurationException {
            CapabilitiesParser parser = new CapabilitiesParser();
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)parser);
            return parser.getCapabilities();
        }
    }
}

