/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class CachedFile {
    protected String name;
    protected long maxAge;
    protected String destDir;
    protected String httpAccept;
    protected CachingStrategy cachingStrategy;
    protected File cacheFile = null;
    protected boolean initialized = false;
    public static final long DEFAULT_MAXTIME = -1L;
    public static final long DAYS = 86400L;

    public CachedFile(String name) {
        this.name = name;
    }

    public CachedFile setName(String name) {
        this.name = name;
        return this;
    }

    public CachedFile setMaxAge(long maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public CachedFile setDestDir(String destDir) {
        this.destDir = destDir;
        return this;
    }

    public CachedFile setHttpAccept(String httpAccept) {
        this.httpAccept = httpAccept;
        return this;
    }

    public CachedFile setCachingStrategy(CachingStrategy cachingStrategy) {
        this.cachingStrategy = cachingStrategy;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public String getHttpAccept() {
        return this.httpAccept;
    }

    public CachingStrategy getCachingStrategy() {
        return this.cachingStrategy;
    }

    public InputStream getInputStream() throws IOException {
        File file = this.getFile();
        if (file == null) {
            if (this.name.startsWith("resource://")) {
                InputStream is = this.getClass().getResourceAsStream(this.name.substring("resource:/".length()));
                if (is == null) {
                    throw new IOException(I18n.tr("Failed to open input stream for resource ''{0}''", this.name));
                }
                return is;
            }
            throw new IOException("No file found for: " + this.name);
        }
        return new FileInputStream(file);
    }

    public synchronized File getFile() throws IOException {
        if (this.initialized) {
            return this.cacheFile;
        }
        this.initialized = true;
        try {
            URL url = new URL(this.name);
            if ("file".equals(url.getProtocol())) {
                this.cacheFile = new File(this.name.substring("file:/".length()));
                if (!this.cacheFile.exists()) {
                    this.cacheFile = new File(this.name.substring("file://".length()));
                }
            } else {
                this.cacheFile = this.checkLocal(url);
            }
        }
        catch (MalformedURLException e) {
            if (this.name.startsWith("resource://")) {
                return null;
            }
            this.cacheFile = this.name.startsWith("josmdir://") ? new File(Main.pref.getUserDataDirectory(), this.name.substring("josmdir://".length())) : (this.name.startsWith("josmplugindir://") ? new File(Main.pref.getPluginsDirectory(), this.name.substring("josmplugindir://".length())) : new File(this.name));
        }
        if (this.cacheFile == null) {
            throw new IOException("Unable to get cache file for " + this.name);
        }
        return this.cacheFile;
    }

    public String findZipEntryPath(String extension, String namepart) {
        Pair<String, InputStream> ze = this.findZipEntryImpl(extension, namepart);
        if (ze == null) {
            return null;
        }
        return (String)ze.a;
    }

    public InputStream findZipEntryInputStream(String extension, String namepart) {
        Pair<String, InputStream> ze = this.findZipEntryImpl(extension, namepart);
        if (ze == null) {
            return null;
        }
        return (InputStream)ze.b;
    }

    private Pair<String, InputStream> findZipEntryImpl(String extension, String namepart) {
        Pair<String, InputStream> res;
        block8: {
            File file = null;
            try {
                file = this.getFile();
            }
            catch (IOException ex) {
                Main.warn(ex, false);
            }
            if (file == null) {
                return null;
            }
            res = null;
            try {
                ZipFile zipFile = new ZipFile(file, StandardCharsets.UTF_8);
                ZipEntry resentry = null;
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith("." + extension) || resentry != null && entry.getName().indexOf(namepart) < 0) continue;
                    resentry = entry;
                }
                if (resentry != null) {
                    InputStream is = zipFile.getInputStream(resentry);
                    res = Pair.create(resentry.getName(), is);
                } else {
                    Utils.close(zipFile);
                }
            }
            catch (Exception e) {
                if (!file.getName().endsWith(".zip")) break block8;
                Main.warn(I18n.tr("Failed to open file with extension ''{2}'' and namepart ''{3}'' in zip file ''{0}''. Exception was: {1}", file.getName(), e.toString(), extension, namepart));
            }
        }
        return res;
    }

    public static void cleanup(String name) {
        CachedFile.cleanup(name, null);
    }

    public static void cleanup(String name, String destDir) {
        try {
            URL url = new URL(name);
            if (!"file".equals(url.getProtocol())) {
                File lfile;
                String prefKey = CachedFile.getPrefKey(url, destDir);
                ArrayList<String> localPath = new ArrayList<String>(Main.pref.getCollection(prefKey));
                if (localPath.size() == 2 && (lfile = new File((String)localPath.get(1))).exists()) {
                    lfile.delete();
                }
                Main.pref.putCollection(prefKey, null);
            }
        }
        catch (MalformedURLException e) {
            Main.warn(e);
        }
    }

    private static String getPrefKey(URL url, String destDir) {
        StringBuilder prefKey = new StringBuilder("mirror.");
        if (destDir != null) {
            prefKey.append(destDir);
            prefKey.append(".");
        }
        prefKey.append(url.toString());
        return prefKey.toString().replaceAll("=", "_");
    }

    private File checkLocal(URL url) throws IOException {
        File destDirFile;
        String prefKey = CachedFile.getPrefKey(url, this.destDir);
        String urlStr = url.toExternalForm();
        long age = 0L;
        long lMaxAge = this.maxAge;
        Long ifModifiedSince = null;
        File localFile = null;
        ArrayList<String> localPathEntry = new ArrayList<String>(Main.pref.getCollection(prefKey));
        boolean offline = false;
        try {
            CachedFile.checkOfflineAccess(urlStr);
        }
        catch (OfflineAccessException e) {
            offline = true;
        }
        if (localPathEntry.size() == 2) {
            localFile = new File((String)localPathEntry.get(1));
            if (!localFile.exists()) {
                localFile = null;
            } else {
                if (this.maxAge == -1L || this.maxAge <= 0L) {
                    lMaxAge = Main.pref.getInteger("mirror.maxtime", 604800);
                }
                age = System.currentTimeMillis() - Long.parseLong((String)localPathEntry.get(0));
                if (offline || age < lMaxAge * 1000L) {
                    return localFile;
                }
                if (this.cachingStrategy == CachingStrategy.IfModifiedSince) {
                    ifModifiedSince = Long.parseLong((String)localPathEntry.get(0));
                }
            }
        }
        if (this.destDir == null) {
            this.destDir = Main.pref.getCacheDirectory().getPath();
        }
        if (!(destDirFile = new File(this.destDir)).exists()) {
            destDirFile.mkdirs();
        }
        if (offline) {
            return null;
        }
        String a = urlStr.replaceAll("[^A-Za-z0-9_.-]", "_");
        String localPath = "mirror_" + a;
        destDirFile = new File(this.destDir, localPath + ".tmp");
        try {
            HttpURLConnection con = CachedFile.connectFollowingRedirect(url, this.httpAccept, ifModifiedSince);
            if (ifModifiedSince != null && con.getResponseCode() == 304) {
                if (Main.isDebugEnabled()) {
                    Main.debug("304 Not Modified (" + urlStr + ")");
                }
                if (localFile == null) {
                    throw new AssertionError();
                }
                Main.pref.putCollection(prefKey, Arrays.asList(Long.toString(System.currentTimeMillis()), (String)localPathEntry.get(1)));
                return localFile;
            }
            try (BufferedInputStream bis = new BufferedInputStream(con.getInputStream());
                 FileOutputStream fos = new FileOutputStream(destDirFile);
                 BufferedOutputStream bos = new BufferedOutputStream(fos);){
                int length;
                byte[] buffer = new byte[4096];
                while ((length = ((InputStream)bis).read(buffer)) > -1) {
                    ((OutputStream)bos).write(buffer, 0, length);
                }
            }
            localFile = new File(this.destDir, localPath);
            if (Main.platform.rename(destDirFile, localFile)) {
                Main.pref.putCollection(prefKey, Arrays.asList(Long.toString(System.currentTimeMillis()), localFile.toString()));
            } else {
                Main.warn(I18n.tr("Failed to rename file {0} to {1}.", destDirFile.getPath(), localFile.getPath()));
            }
        }
        catch (IOException e) {
            if (age >= lMaxAge * 1000L && age < lMaxAge * 1000L * 2L) {
                Main.warn(I18n.tr("Failed to load {0}, use cached file and retry next time: {1}", urlStr, e));
                return localFile;
            }
            throw e;
        }
        return localFile;
    }

    private static void checkOfflineAccess(String urlString) {
        OnlineResource.JOSM_WEBSITE.checkOfflineAccess(urlString, Main.getJOSMWebsite());
        OnlineResource.OSM_API.checkOfflineAccess(urlString, Main.pref.get("osm-server.url", "https://api.openstreetmap.org/api"));
    }

    public static HttpURLConnection connectFollowingRedirect(URL downloadUrl, String httpAccept, Long ifModifiedSince) throws MalformedURLException, IOException {
        CheckParameterUtil.ensureParameterNotNull(downloadUrl, "downloadUrl");
        String downloadString = downloadUrl.toExternalForm();
        CachedFile.checkOfflineAccess(downloadString);
        HttpURLConnection con = null;
        int numRedirects = 0;
        block7: while (true) {
            if ((con = Utils.openHttpConnection(downloadUrl)) == null) {
                throw new IOException("Cannot open http connection to " + downloadString);
            }
            if (ifModifiedSince != null) {
                con.setIfModifiedSince(ifModifiedSince);
            }
            con.setInstanceFollowRedirects(false);
            con.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
            con.setReadTimeout(Main.pref.getInteger("socket.timeout.read", 30) * 1000);
            if (Main.isDebugEnabled()) {
                Main.debug("GET " + downloadString);
            }
            if (httpAccept != null) {
                if (Main.isTraceEnabled()) {
                    Main.trace("Accept: " + httpAccept);
                }
                con.setRequestProperty("Accept", httpAccept);
            }
            try {
                con.connect();
            }
            catch (IOException e) {
                Main.addNetworkError(downloadUrl, Utils.getRootCause(e));
                throw e;
            }
            switch (con.getResponseCode()) {
                case 200: {
                    return con;
                }
                case 304: {
                    if (ifModifiedSince != null) {
                        return con;
                    }
                }
                case 301: 
                case 302: 
                case 303: {
                    String redirectLocation = con.getHeaderField("Location");
                    if (redirectLocation == null) {
                        String msg = I18n.tr("Unexpected response from HTTP server. Got {0} response without ''Location'' header. Can''t redirect. Aborting.", con.getResponseCode());
                        throw new IOException(msg);
                    }
                    downloadUrl = new URL(redirectLocation);
                    downloadString = downloadUrl.toExternalForm();
                    if (++numRedirects >= Main.pref.getInteger("socket.maxredirects", 5)) {
                        String msg = I18n.tr("Too many redirects to the download URL detected. Aborting.", new Object[0]);
                        throw new IOException(msg);
                    }
                    Main.info(I18n.tr("Download redirected to ''{0}''", downloadString));
                    continue block7;
                }
            }
            break;
        }
        String msg = I18n.tr("Failed to read from ''{0}''. Server responded with status code {1}.", downloadString, con.getResponseCode());
        throw new IOException(msg);
    }

    public static enum CachingStrategy {
        MaxAge,
        IfModifiedSince;

    }
}

