/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.OfflineAccessException;

public abstract class CacheCustomContent<T extends Throwable> {
    public static final int INTERVAL_ALWAYS = -1;
    public static final int INTERVAL_HOURLY = 3600;
    public static final int INTERVAL_DAILY = 86400;
    public static final int INTERVAL_WEEKLY = 604800;
    public static final int INTERVAL_MONTHLY = 2419200;
    public static final int INTERVAL_NEVER = Integer.MAX_VALUE;
    private byte[] data = null;
    private final String ident;
    private final File path;
    private final int updateInterval;

    protected abstract byte[] updateData() throws T;

    protected boolean isCacheValid() {
        return true;
    }

    public CacheCustomContent(String ident, int updateInterval) {
        this.ident = ident;
        this.updateInterval = updateInterval;
        this.path = new File(Main.pref.getCacheDirectory(), ident);
    }

    private boolean needsUpdate() {
        if (this.isOffline()) {
            return false;
        }
        return (long)(Main.pref.getInteger("cache." + this.ident, 0) + this.updateInterval) < System.currentTimeMillis() / 1000L || !this.isCacheValid();
    }

    private boolean isOffline() {
        try {
            this.checkOfflineAccess();
            return false;
        }
        catch (OfflineAccessException e) {
            return true;
        }
    }

    protected void checkOfflineAccess() {
    }

    public byte[] updateIfRequired() throws T {
        if (this.needsUpdate()) {
            return this.updateForce();
        }
        return this.getData();
    }

    public String updateIfRequiredString() throws T {
        if (this.needsUpdate()) {
            return this.updateForceString();
        }
        return this.getDataString();
    }

    public byte[] updateForce() throws T {
        this.data = this.updateData();
        this.saveToDisk();
        Main.pref.putInteger("cache." + this.ident, (int)(System.currentTimeMillis() / 1000L));
        return this.data;
    }

    public String updateForceString() throws T {
        this.updateForce();
        return new String(this.data, StandardCharsets.UTF_8);
    }

    public byte[] getData() throws T {
        if (this.data == null) {
            this.loadFromDisk();
        }
        return this.data;
    }

    public String getDataString() throws T {
        byte[] array = this.getData();
        if (array == null) {
            return null;
        }
        return new String(array, StandardCharsets.UTF_8);
    }

    private void loadFromDisk() throws T {
        block14: {
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.path));){
                this.data = new byte[input.available()];
                input.read(this.data);
            }
            catch (IOException e) {
                if (this.isOffline()) break block14;
                this.data = this.updateForce();
            }
        }
    }

    private void saveToDisk() {
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.path));){
            output.write(this.data);
            output.flush();
        }
        catch (IOException e) {
            Main.error(e);
        }
    }

    public void flushData() {
        this.data = null;
    }
}

