/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.NoteReader;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class BoundingBoxDownloader
extends OsmServerReader {
    protected final double lat1;
    protected final double lon1;
    protected final double lat2;
    protected final double lon2;
    protected final boolean crosses180th;

    public BoundingBoxDownloader(Bounds downloadArea) {
        CheckParameterUtil.ensureParameterNotNull(downloadArea, "downloadArea");
        this.lat1 = downloadArea.getMinLat();
        this.lon1 = downloadArea.getMinLon();
        this.lat2 = downloadArea.getMaxLat();
        this.lon2 = downloadArea.getMaxLon();
        this.crosses180th = downloadArea.crosses180thMeridian();
    }

    private GpxData downloadRawGps(Bounds b, ProgressMonitor progressMonitor) throws IOException, OsmTransferException, SAXException {
        boolean done = false;
        GpxData result = null;
        String url = "trackpoints?bbox=" + b.getMinLon() + "," + b.getMinLat() + "," + b.getMaxLon() + "," + b.getMaxLat() + "&page=";
        int i = 0;
        while (!done) {
            progressMonitor.subTask(I18n.tr("Downloading points {0} to {1}...", i * 5000, (i + 1) * 5000));
            try (InputStream in = this.getInputStream(url + i, progressMonitor.createSubTaskMonitor(1, true));){
                if (in == null) break;
                progressMonitor.setTicks(0);
                GpxReader reader = new GpxReader(in);
                this.gpxParsedProperly = reader.parse(false);
                GpxData currentGpx = reader.getGpxData();
                if (result == null) {
                    result = currentGpx;
                } else if (currentGpx.hasTrackPoints()) {
                    result.mergeFrom(currentGpx);
                } else {
                    done = true;
                }
            }
            this.activeConnection = null;
            ++i;
        }
        if (result != null) {
            result.fromServer = true;
            result.dataSources.add(new DataSource(b, "OpenStreetMap server"));
        }
        return result;
    }

    @Override
    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask("", 1);
        try {
            progressMonitor.indeterminateSubTask(I18n.tr("Contacting OSM Server...", new Object[0]));
            if (this.crosses180th) {
                GpxData result = this.downloadRawGps(new Bounds(this.lat1, this.lon1, this.lat2, 180.0), progressMonitor);
                result.mergeFrom(this.downloadRawGps(new Bounds(this.lat1, -180.0, this.lat2, this.lon2), progressMonitor));
                GpxData gpxData = result;
                return gpxData;
            }
            GpxData result = this.downloadRawGps(new Bounds(this.lat1, this.lon1, this.lat2, this.lon2), progressMonitor);
            return result;
        }
        catch (IllegalArgumentException e) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw new OsmTransferException("Illegal characters within the HTTP-header response.", e);
        }
        catch (IOException e) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw new OsmTransferException(e);
        }
        catch (SAXException e) {
            throw new OsmTransferException(e);
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw e;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected String getRequestForBbox(double lon1, double lat1, double lon2, double lat2) {
        return "map?bbox=" + lon1 + "," + lat1 + "," + lon2 + "," + lat2;
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(I18n.tr("Contacting OSM Server...", new Object[0]), 10);
        try {
            DataSet ds = null;
            progressMonitor.indeterminateSubTask(null);
            if (this.crosses180th) {
                DataSet ds2 = null;
                try (InputStream in = this.getInputStream(this.getRequestForBbox(this.lon1, this.lat1, 180.0, this.lat2), progressMonitor.createSubTaskMonitor(9, false));){
                    if (in == null) {
                        DataSet dataSet = null;
                        return dataSet;
                    }
                    ds = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, false));
                }
                in = this.getInputStream(this.getRequestForBbox(-180.0, this.lat1, this.lon2, this.lat2), progressMonitor.createSubTaskMonitor(9, false));
                var5_8 = null;
                try {
                    if (in == null) {
                        DataSet x2 = null;
                        return x2;
                    }
                    ds2 = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, false));
                }
                catch (Throwable x2) {
                    var5_8 = x2;
                    throw x2;
                }
                finally {
                    if (in != null) {
                        if (var5_8 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable x2) {
                                var5_8.addSuppressed(x2);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
                if (ds2 == null) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                ds.mergeFrom(ds2);
            } else {
                try (InputStream in = this.getInputStream(this.getRequestForBbox(this.lon1, this.lat1, this.lon2, this.lat2), progressMonitor.createSubTaskMonitor(9, false));){
                    if (in == null) {
                        DataSet dataSet = null;
                        return dataSet;
                    }
                    ds = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, false));
                }
            }
            DataSet dataSet = ds;
            return dataSet;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
        }
    }

    @Override
    public List<Note> parseNotes(Integer noteLimit, Integer daysClosed, ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask("Downloading notes");
        noteLimit = this.checkNoteLimit(noteLimit);
        daysClosed = this.checkDaysClosed(daysClosed);
        String url = "notes?limit=" + noteLimit + "&closed=" + daysClosed + "&bbox=" + this.lon1 + "," + this.lat1 + "," + this.lon2 + "," + this.lat2;
        try {
            InputStream is = this.getInputStream(url, progressMonitor.createSubTaskMonitor(1, false));
            NoteReader reader = new NoteReader(is);
            List<Note> list = reader.parse();
            return list;
        }
        catch (IOException e) {
            throw new OsmTransferException(e);
        }
        catch (SAXException e) {
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private Integer checkNoteLimit(Integer limit) {
        if (limit == null) {
            limit = Main.pref.getInteger("osm.notes.downloadLimit", 1000);
        }
        if (limit > 10000) {
            Main.error("Requested note limit is over API hard limit of 10000. Reducing to 10000.");
            limit = 10000;
        }
        if (limit < 1) {
            Main.error("Requested note limit is less than 1. Setting to 1.");
            limit = 1;
        }
        Main.debug("returning note limit: " + limit);
        return limit;
    }

    private Integer checkDaysClosed(Integer days) {
        if (days == null) {
            days = Main.pref.getInteger("osm.notes.daysClosed", 7);
        }
        if (days < -1) {
            Main.error("Requested days closed must be greater than -1");
            days = -1;
        }
        Main.debug("returning days closed: " + days);
        return days;
    }
}

