/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import javax.swing.JEditorPane;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.html.StyleSheet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmHTMLEditorKit;
import org.openstreetmap.josm.gui.widgets.TextContextualPopupMenu;
import org.openstreetmap.josm.tools.Utils;

public class JosmEditorPane
extends JEditorPane {
    public JosmEditorPane() {
        TextContextualPopupMenu.enableMenuFor(this, true);
    }

    public JosmEditorPane(URL initialPage) throws IOException {
        this();
        this.setPage(initialPage);
    }

    public JosmEditorPane(String url) throws IOException {
        this();
        this.setPage(url);
    }

    public JosmEditorPane(String type, String text) {
        this();
        this.setContentType(type);
        this.setText(text);
    }

    @Override
    protected InputStream getStream(URL page) throws IOException {
        URLConnection conn = Utils.setupURLConnection(page.openConnection());
        InputStream result = conn.getInputStream();
        String type = conn.getContentType();
        if (type != null) {
            this.setContentType(type);
        }
        return result;
    }

    public static void makeJLabelLike(JEditorPane pane, boolean allBold) {
        pane.setContentType("text/html");
        pane.setOpaque(false);
        pane.setEditable(false);
        JosmEditorPane.adaptForNimbus(pane);
        JosmHTMLEditorKit kit = new JosmHTMLEditorKit();
        Font f = UIManager.getFont("Label.font");
        StyleSheet ss = new StyleSheet();
        ss.addRule((allBold ? "html" : "strong, b") + " {" + JosmEditorPane.getFontRule(f) + "}");
        ss.addRule("a {text-decoration: underline; color: blue}");
        ss.addRule("h1 {" + JosmEditorPane.getFontRule(GuiHelper.getTitleFont()) + "}");
        ss.addRule("ol {margin-left: 1cm; margin-top: 0.1cm; margin-bottom: 0.2cm; list-style-type: decimal}");
        ss.addRule("ul {margin-left: 1cm; margin-top: 0.1cm; margin-bottom: 0.2cm; list-style-type: disc}");
        if ("km".equals(Main.pref.get("language"))) {
            ss.addRule("p {" + JosmEditorPane.getFontRule(UIManager.getFont("Label.font")) + "}");
        }
        kit.setStyleSheet(ss);
        pane.setEditorKit(kit);
    }

    public static void adaptForNimbus(JEditorPane pane) {
        LookAndFeel currentLAF = UIManager.getLookAndFeel();
        if (currentLAF != null && "Nimbus".equals(currentLAF.getName())) {
            Color bgColor = UIManager.getColor("Label.background");
            UIDefaults defaults = new UIDefaults();
            defaults.put("EditorPane[Enabled].backgroundPainter", bgColor);
            pane.putClientProperty("Nimbus.Overrides", defaults);
            pane.putClientProperty("Nimbus.Overrides.InheritDefaults", true);
            pane.setBackground(bgColor);
        }
    }

    private static String getFontRule(Font f) {
        return MessageFormat.format("font-family: ''{0}'';font-size: {1,number}pt; font-weight: {2}; font-style: {3}", f.getName(), f.getSize(), "bold", f.isItalic() ? "italic" : "normal");
    }
}

