/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.util.List;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.widgets.ComboBoxHistory;

public class HistoryComboBox
extends AutoCompletingComboBox {
    private ComboBoxHistory model;
    public static final int DEFAULT_SEARCH_HISTORY_SIZE = 15;

    public HistoryComboBox() {
        int maxsize = Main.pref.getInteger("search.history-size", 15);
        this.model = new ComboBoxHistory(maxsize);
        this.setModel(this.model);
        this.setEditable(true);
    }

    public String getText() {
        return ((JTextComponent)this.getEditor().getEditorComponent()).getText();
    }

    public void setText(String value) {
        this.setAutocompleteEnabled(false);
        ((JTextComponent)this.getEditor().getEditorComponent()).setText(value);
        this.setAutocompleteEnabled(true);
    }

    public void addCurrentItemToHistory() {
        this.model.addElement((String)this.getEditor().getItem());
    }

    public void setHistory(List<String> history) {
        this.model.setItemsAsString(history);
    }

    public List<String> getHistory() {
        return this.model.asStringList();
    }
}

