/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.NativeFileChooser;
import org.openstreetmap.josm.gui.widgets.SwingFileChooser;

public class FileChooserManager {
    public static final BooleanProperty PROP_USE_NATIVE_FILE_DIALOG = new BooleanProperty("use.native.file.dialog", Main.isPlatformOsx());
    private final boolean open;
    private final String lastDirProperty;
    private final String curDir;
    private AbstractFileChooser fc;

    public FileChooserManager(boolean open) {
        this(open, null);
    }

    public FileChooserManager(boolean open, String lastDirProperty) {
        this(open, lastDirProperty, null);
    }

    public FileChooserManager(boolean open, String lastDirProperty, String defaultDir) {
        this.open = open;
        String string = this.lastDirProperty = lastDirProperty == null || lastDirProperty.isEmpty() ? "lastDirectory" : lastDirProperty;
        this.curDir = Main.pref.get(this.lastDirProperty).isEmpty() ? (defaultDir == null || defaultDir.isEmpty() ? "." : defaultDir) : Main.pref.get(this.lastDirProperty);
    }

    public final AbstractFileChooser getFileChooser() {
        return this.fc;
    }

    public final String getInitialDirectory() {
        return this.curDir;
    }

    public final FileChooserManager createFileChooser() {
        return this.doCreateFileChooser(false, null, null, null, null, 0, false);
    }

    public final FileChooserManager createFileChooser(boolean multiple, String title, FileFilter filter, int selectionMode) {
        this.doCreateFileChooser(multiple, title, Collections.singleton(filter), filter, null, selectionMode, false);
        this.getFileChooser().setAcceptAllFileFilterUsed(false);
        return this;
    }

    public final FileChooserManager createFileChooser(boolean multiple, String title, Collection<? extends FileFilter> filters, FileFilter defaultFilter, int selectionMode) {
        return this.doCreateFileChooser(multiple, title, filters, defaultFilter, null, selectionMode, false);
    }

    public final FileChooserManager createFileChooser(boolean multiple, String title, String extension, boolean allTypes, int selectionMode) {
        return this.doCreateFileChooser(multiple, title, null, null, extension, selectionMode, allTypes);
    }

    private final FileChooserManager doCreateFileChooser(boolean multiple, String title, Collection<? extends FileFilter> filters, FileFilter defaultFilter, String extension, int selectionMode, boolean allTypes) {
        File file = new File(this.curDir);
        this.fc = PROP_USE_NATIVE_FILE_DIALOG.get() != false && NativeFileChooser.supportsSelectionMode(selectionMode) ? new NativeFileChooser(file) : new SwingFileChooser(file);
        if (title != null) {
            this.fc.setDialogTitle(title);
        }
        this.fc.setFileSelectionMode(selectionMode);
        this.fc.setMultiSelectionEnabled(multiple);
        this.fc.setAcceptAllFileFilterUsed(false);
        if (filters != null) {
            for (FileFilter fileFilter : filters) {
                this.fc.addChoosableFileFilter(fileFilter);
            }
            if (defaultFilter != null) {
                this.fc.setFileFilter(defaultFilter);
            }
        } else if (this.open) {
            ExtensionFileFilter.applyChoosableImportFileFilters(this.fc, extension, allTypes);
        } else {
            ExtensionFileFilter.applyChoosableExportFileFilters(this.fc, extension, allTypes);
        }
        return this;
    }

    public final AbstractFileChooser openFileChooser() {
        return this.openFileChooser(null);
    }

    public AbstractFileChooser openFileChooser(Component parent) {
        if (this.fc != null) {
            File file;
            int answer;
            if (parent == null) {
                parent = Main.parent;
            }
            int n = answer = this.open ? this.fc.showOpenDialog(parent) : this.fc.showSaveDialog(parent);
            if (answer != 0) {
                return null;
            }
            if (!this.fc.getCurrentDirectory().getAbsolutePath().equals(this.curDir)) {
                Main.pref.put(this.lastDirProperty, this.fc.getCurrentDirectory().getAbsolutePath());
            }
            if (!this.open && !SaveActionBase.confirmOverwrite(file = this.fc.getSelectedFile())) {
                return null;
            }
        }
        return this.fc;
    }
}

