/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.date.DateUtils;

public class DateEditorWithSlider
extends JPanel {
    private JSpinner spinner;
    private JSlider slider;
    private Date dateMin;
    private Date dateMax;
    private boolean watchSlider = true;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public DateEditorWithSlider(String labelText) {
        super(new GridBagLayout());
        this.spinner = new JSpinner(new SpinnerDateModel());
        String pattern = ((SimpleDateFormat)DateUtils.getDateFormat(2)).toPattern();
        JSpinner.DateEditor timeEditor = new JSpinner.DateEditor(this.spinner, pattern);
        this.spinner.setEditor(timeEditor);
        this.spinner.setPreferredSize(new Dimension(this.spinner.getPreferredSize().width + 5, this.spinner.getPreferredSize().height));
        this.slider = new JSlider(0, 300);
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Date d;
                int j;
                int i = DateEditorWithSlider.this.slider.getValue();
                if (i != (j = DateEditorWithSlider.this.intFromDate(d = (Date)DateEditorWithSlider.this.spinner.getValue()))) {
                    DateEditorWithSlider.this.watchSlider = false;
                    DateEditorWithSlider.this.slider.setValue(j);
                    DateEditorWithSlider.this.watchSlider = true;
                }
                for (ChangeListener l : DateEditorWithSlider.this.listeners) {
                    l.stateChanged(e);
                }
            }
        });
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Date d1;
                if (!DateEditorWithSlider.this.watchSlider) {
                    return;
                }
                Date d = (Date)DateEditorWithSlider.this.spinner.getValue();
                if (!d.equals(d1 = DateEditorWithSlider.this.dateFromInt(DateEditorWithSlider.this.slider.getValue()))) {
                    DateEditorWithSlider.this.spinner.setValue(d1);
                }
            }
        });
        this.add((Component)new JLabel(labelText), GBC.std());
        this.add((Component)this.spinner, GBC.std().insets(10, 0, 0, 0));
        this.add((Component)this.slider, GBC.eol().insets(10, 0, 0, 0).fill(2));
        this.dateMin = new Date(0L);
        this.dateMax = new Date();
    }

    protected Date dateFromInt(int value) {
        double k = 1.0 * (double)value / 300.0;
        return new Date((long)((double)this.dateMax.getTime() * k + (double)this.dateMin.getTime() * (1.0 - k)));
    }

    protected int intFromDate(Date date) {
        return (int)(300.0 * (double)(date.getTime() - this.dateMin.getTime()) / (double)(this.dateMax.getTime() - this.dateMin.getTime()));
    }

    public void setRange(Date dateMin, Date dateMax) {
        this.dateMin = dateMin;
        this.dateMax = dateMax;
    }

    public void setDate(Date date) {
        this.spinner.setValue(date);
    }

    public Date getDate() {
        return (Date)this.spinner.getValue();
    }

    public void addDateListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeDateListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }
}

