/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.widgets.HistoryChangedListener;

public class ComboBoxHistory
extends DefaultComboBoxModel<AutoCompletionListItem>
implements Iterable<AutoCompletionListItem> {
    private int maxSize = 10;
    private List<HistoryChangedListener> listeners = new ArrayList<HistoryChangedListener>();

    public ComboBoxHistory(int size) {
        this.maxSize = size;
    }

    @Override
    public void addElement(String s) {
        this.addElement(new AutoCompletionListItem(s));
    }

    @Override
    public void addElement(AutoCompletionListItem o) {
        String newEntry = o.getValue();
        for (int i = 0; i < this.getSize(); ++i) {
            String oldEntry = ((AutoCompletionListItem)this.getElementAt(i)).getValue();
            if (!oldEntry.equals(newEntry)) continue;
            this.removeElementAt(i);
        }
        this.insertElementAt(o, 0);
        if (this.getSize() > this.maxSize) {
            this.removeElementAt(this.getSize() - 1);
        }
        this.setSelectedItem(o);
        this.fireHistoryChanged();
    }

    @Override
    public Iterator<AutoCompletionListItem> iterator() {
        return new Iterator<AutoCompletionListItem>(){
            private int position = -1;

            @Override
            public void remove() {
                ComboBoxHistory.this.removeElementAt(this.position);
            }

            @Override
            public boolean hasNext() {
                return this.position < ComboBoxHistory.this.getSize() - 1 && ComboBoxHistory.this.getSize() > 0;
            }

            @Override
            public AutoCompletionListItem next() {
                ++this.position;
                return (AutoCompletionListItem)ComboBoxHistory.this.getElementAt(this.position);
            }
        };
    }

    public void setItemsAsString(List<String> items) {
        this.removeAllElements();
        for (int i = items.size() - 1; i >= 0; --i) {
            this.addElement(new AutoCompletionListItem(items.get(i)));
        }
    }

    public List<String> asStringList() {
        ArrayList<String> list = new ArrayList<String>(this.maxSize);
        for (AutoCompletionListItem item : this) {
            list.add(item.getValue());
        }
        return list;
    }

    public void addHistoryChangedListener(HistoryChangedListener l) {
        this.listeners.add(l);
    }

    public void removeHistoryChangedListener(HistoryChangedListener l) {
        this.listeners.remove(l);
    }

    private void fireHistoryChanged() {
        for (HistoryChangedListener l : this.listeners) {
            l.historyChanged(this.asStringList());
        }
    }
}

