/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public class BoundingBoxSelectionPanel
extends JPanel {
    private JosmTextField[] tfLatLon = null;
    private final JosmTextField tfOsmUrl = new JosmTextField();

    protected void buildInputFields() {
        this.tfLatLon = new JosmTextField[4];
        for (int i = 0; i < 4; ++i) {
            this.tfLatLon[i] = new JosmTextField(11);
            this.tfLatLon[i].setMinimumSize(new Dimension(100, new JosmTextField().getMinimumSize().height));
            SelectAllOnFocusGainedDecorator.decorate(this.tfLatLon[i]);
        }
        LatitudeValidator.decorate(this.tfLatLon[0]);
        LatitudeValidator.decorate(this.tfLatLon[2]);
        LongitudeValidator.decorate(this.tfLatLon[1]);
        LongitudeValidator.decorate(this.tfLatLon[3]);
    }

    protected final void build() {
        this.buildInputFields();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        this.tfOsmUrl.getDocument().addDocumentListener(new OsmUrlRefresher());
        this.tfOsmUrl.addFocusListener(new SelectAllOnFocusGainedDecorator());
        this.add((Component)new JLabel(I18n.tr("Min. latitude", new Object[0])), GBC.std().insets(0, 0, 3, 5));
        this.add((Component)this.tfLatLon[0], GBC.std().insets(0, 0, 3, 5));
        this.add((Component)new JLabel(I18n.tr("Min. longitude", new Object[0])), GBC.std().insets(0, 0, 3, 5));
        this.add((Component)this.tfLatLon[1], GBC.eol());
        this.add((Component)new JLabel(I18n.tr("Max. latitude", new Object[0])), GBC.std().insets(0, 0, 3, 5));
        this.add((Component)this.tfLatLon[2], GBC.std().insets(0, 0, 3, 5));
        this.add((Component)new JLabel(I18n.tr("Max. longitude", new Object[0])), GBC.std().insets(0, 0, 3, 5));
        this.add((Component)this.tfLatLon[3], GBC.eol());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 4;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.insets = new Insets(10, 0, 0, 3);
        this.add((Component)new JMultilineLabel(I18n.tr("URL from www.openstreetmap.org (you can paste a download URL here to specify a bounding box)", new Object[0])), gc);
        gc.gridy = 3;
        gc.insets = new Insets(3, 0, 0, 3);
        this.add((Component)this.tfOsmUrl, gc);
    }

    public BoundingBoxSelectionPanel() {
        this.build();
    }

    public void setBoundingBox(Bounds area) {
        this.updateBboxFields(area);
    }

    public Bounds getBoundingBox() {
        double maxlon;
        double maxlat;
        double minlon;
        double minlat;
        try {
            minlat = Double.parseDouble(this.tfLatLon[0].getText().trim());
            minlon = Double.parseDouble(this.tfLatLon[1].getText().trim());
            maxlat = Double.parseDouble(this.tfLatLon[2].getText().trim());
            maxlon = Double.parseDouble(this.tfLatLon[3].getText().trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (!(LatLon.isValidLon(minlon) && LatLon.isValidLon(maxlon) && LatLon.isValidLat(minlat) && LatLon.isValidLat(maxlat))) {
            return null;
        }
        if (minlon > maxlon) {
            return null;
        }
        if (minlat > maxlat) {
            return null;
        }
        return new Bounds(minlon, minlat, maxlon, maxlat);
    }

    private boolean parseURL() {
        Bounds b = OsmUrlToBounds.parse(this.tfOsmUrl.getText());
        if (b == null) {
            return false;
        }
        this.updateBboxFields(b);
        return true;
    }

    private void updateBboxFields(Bounds area) {
        if (area == null) {
            return;
        }
        this.tfLatLon[0].setText(area.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES));
        this.tfLatLon[1].setText(area.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES));
        this.tfLatLon[2].setText(area.getMax().latToString(CoordinateFormat.DECIMAL_DEGREES));
        this.tfLatLon[3].setText(area.getMax().lonToString(CoordinateFormat.DECIMAL_DEGREES));
    }

    class OsmUrlRefresher
    implements DocumentListener {
        OsmUrlRefresher() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            BoundingBoxSelectionPanel.this.parseURL();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            BoundingBoxSelectionPanel.this.parseURL();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            BoundingBoxSelectionPanel.this.parseURL();
        }
    }

    private static class LongitudeValidator
    extends AbstractTextComponentValidator {
        public static void decorate(JTextComponent tc) {
            new LongitudeValidator(tc);
        }

        public LongitudeValidator(JTextComponent tc) {
            super(tc);
        }

        @Override
        public void validate() {
            double value = 0.0;
            try {
                value = Double.parseDouble(this.getComponent().getText());
            }
            catch (NumberFormatException ex) {
                this.feedbackInvalid(I18n.tr("The string ''{0}'' is not a valid double value.", this.getComponent().getText()));
                return;
            }
            if (!LatLon.isValidLon(value)) {
                this.feedbackInvalid(I18n.tr("Value for longitude in range [-180,180] required.", this.getComponent().getText()));
                return;
            }
            this.feedbackValid("");
        }

        @Override
        public boolean isValid() {
            double value = 0.0;
            try {
                value = Double.parseDouble(this.getComponent().getText());
            }
            catch (NumberFormatException ex) {
                return false;
            }
            return LatLon.isValidLon(value);
        }
    }

    private static class LatitudeValidator
    extends AbstractTextComponentValidator {
        public static void decorate(JTextComponent tc) {
            new LatitudeValidator(tc);
        }

        public LatitudeValidator(JTextComponent tc) {
            super(tc);
        }

        @Override
        public void validate() {
            double value = 0.0;
            try {
                value = Double.parseDouble(this.getComponent().getText());
            }
            catch (NumberFormatException ex) {
                this.feedbackInvalid(I18n.tr("The string ''{0}'' is not a valid double value.", this.getComponent().getText()));
                return;
            }
            if (!LatLon.isValidLat(value)) {
                this.feedbackInvalid(I18n.tr("Value for latitude in range [-90,90] required.", this.getComponent().getText()));
                return;
            }
            this.feedbackValid("");
        }

        @Override
        public boolean isValid() {
            double value = 0.0;
            try {
                value = Double.parseDouble(this.getComponent().getText());
            }
            catch (NumberFormatException ex) {
                return false;
            }
            return LatLon.isValidLat(value);
        }
    }
}

