/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.FilteredImageSource;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class GuiHelper {
    public static void setEnabledRec(Container root, boolean enabled) {
        Component[] children;
        root.setEnabled(enabled);
        for (Component child : children = root.getComponents()) {
            if (child instanceof Container) {
                GuiHelper.setEnabledRec((Container)child, enabled);
                continue;
            }
            child.setEnabled(enabled);
        }
    }

    public static void executeByMainWorkerInEDT(final Runnable task) {
        Main.worker.submit(new Runnable(){

            @Override
            public void run() {
                GuiHelper.runInEDTAndWait(task);
            }
        });
    }

    public static void runInEDT(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    public static void runInEDTAndWait(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(task);
            }
            catch (InterruptedException | InvocationTargetException e) {
                Main.error(e);
            }
        }
    }

    public static <V> V runInEDTAndWaitAndReturn(Callable<V> callable) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                Main.error(e);
                return null;
            }
        }
        FutureTask<V> task = new FutureTask<V>(callable);
        SwingUtilities.invokeLater(task);
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Main.error(e);
            return null;
        }
    }

    public static final boolean warnUser(String title, String content, ImageIcon baseActionIcon, String continueToolTip) {
        ExtendedDialog dlg = new ExtendedDialog(Main.parent, title, new String[]{I18n.tr("Cancel", new Object[0]), I18n.tr("Continue", new Object[0])});
        dlg.setContent(content);
        dlg.setButtonIcons(new Icon[]{ImageProvider.get("cancel"), ImageProvider.overlay(ImageProvider.get("upload"), new ImageIcon(ImageProvider.get("warning-small").getImage().getScaledInstance(10, 10, 4)), ImageProvider.OverlayPosition.SOUTHEAST)});
        dlg.setToolTipTexts(new String[]{I18n.tr("Cancel", new Object[0]), continueToolTip});
        dlg.setIcon(2);
        dlg.setCancelButton(1);
        return dlg.showDialog().getValue() != 2;
    }

    public static final void notifyUserHtmlError(Component parent, String title, String message, String html) {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(message), GBC.eol());
        p.add((Component)new JLabel(I18n.tr("Received error page:", new Object[0])), GBC.eol());
        JScrollPane sp = GuiHelper.embedInVerticalScrollPane(new HtmlPanel(html));
        sp.setPreferredSize(new Dimension(640, 240));
        p.add((Component)sp, GBC.eol().fill(1));
        ExtendedDialog ed = new ExtendedDialog(parent, title, new String[]{I18n.tr("OK", new Object[0])});
        ed.setButtonIcons(new String[]{"ok.png"});
        ed.setContent(p);
        ed.showDialog();
    }

    public static final Image getDisabledImage(Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new GrayFilter(true, 20)));
    }

    public static final ImageIcon getDisabledIcon(ImageIcon icon) {
        return new ImageIcon(GuiHelper.getDisabledImage(icon.getImage()));
    }

    public static final Component prepareResizeableOptionPane(final Component pane, final Dimension minDimension) {
        if (pane != null) {
            pane.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    Dialog dialog;
                    Window window = SwingUtilities.getWindowAncestor(pane);
                    if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                        dialog.setResizable(true);
                        if (minDimension != null) {
                            dialog.setMinimumSize(minDimension);
                        }
                    }
                }
            });
        }
        return pane;
    }

    public static final Timer scheduleTimer(int initialDelay, ActionListener actionListener, boolean repeats) {
        Timer timer = new Timer(initialDelay, actionListener);
        timer.setRepeats(repeats);
        timer.start();
        return timer;
    }

    public static Stroke getCustomizedStroke(String code) {
        float w;
        String[] s = code.trim().split("[^\\.0-9]+");
        if (s.length == 0) {
            return new BasicStroke();
        }
        try {
            w = Float.parseFloat(s[0]);
        }
        catch (NumberFormatException ex) {
            w = 1.0f;
        }
        if (s.length > 1) {
            float[] dash = new float[s.length - 1];
            float sumAbs = 0.0f;
            try {
                for (int i = 0; i < s.length - 1; ++i) {
                    dash[i] = Float.parseFloat(s[i + 1]);
                    sumAbs += Math.abs(dash[i]);
                }
            }
            catch (NumberFormatException ex) {
                Main.error("Error in stroke preference format: " + code);
                dash = new float[]{5.0f};
            }
            if ((double)sumAbs < 0.1) {
                Main.error("Error in stroke dash fomat (all zeros): " + code);
                return new BasicStroke(w);
            }
            return new BasicStroke(w, 0, 0, 10.0f, dash, 0.0f);
        }
        if (w > 1.0f) {
            return new BasicStroke(w, 1, 1);
        }
        return new BasicStroke(w);
    }

    public static Font getMonospacedFont(JComponent component) {
        if ("km".equals(Main.pref.get("language"))) {
            return component.getFont();
        }
        return new Font("Monospaced", component.getFont().getStyle(), component.getFont().getSize());
    }

    public static Font getTitleFont() {
        List<String> fonts = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        if ("km".equals(Main.pref.get("language"))) {
            return UIManager.getFont("Label.font").deriveFont(20.0f);
        }
        if (fonts.contains("Helvetica")) {
            return new Font("Helvetica", 1, 20);
        }
        if (fonts.contains("Calibri")) {
            return new Font("Calibri", 1, 23);
        }
        if (fonts.contains("Arial")) {
            return new Font("Arial", 1, 20);
        }
        return new Font("SansSerif", 1, 20);
    }

    public static JScrollPane embedInVerticalScrollPane(Component panel) {
        return new JScrollPane(panel, 20, 31);
    }

    public static int getMenuShortcutKeyMaskEx() {
        return Main.isPlatformOsx() ? 256 : 128;
    }

    public static void setUIFont(String name) {
        CheckParameterUtil.ensureParameterNotNull(name, "name");
        Main.info("Setting " + name + " as the default UI font");
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            FontUIResource fui = (FontUIResource)value;
            UIManager.put(key, new FontUIResource(name, fui.getStyle(), fui.getSize()));
        }
    }
}

