/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedKeyPressDetector
implements AWTEventListener {
    private final Set<Integer> set = new TreeSet<Integer>();
    private KeyEvent releaseEvent;
    private Timer timer;
    private final ArrayList<KeyPressReleaseListener> keyListeners = new ArrayList();
    private final ArrayList<ModifierListener> modifierListeners = new ArrayList();
    private int previousModifiers;
    private boolean enabled = true;

    public synchronized void addKeyListener(KeyPressReleaseListener l) {
        this.keyListeners.add(l);
    }

    public synchronized void addModifierListener(ModifierListener l) {
        this.modifierListeners.add(l);
    }

    public synchronized void removeKeyListener(KeyPressReleaseListener l) {
        this.keyListeners.remove(l);
    }

    public synchronized void removeModifierListener(ModifierListener l) {
        this.modifierListeners.remove(l);
    }

    public void register() {
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException ex) {
            Main.warn(ex);
        }
        this.timer = new Timer(0, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedKeyPressDetector.this.timer.stop();
                if (AdvancedKeyPressDetector.this.set.remove(AdvancedKeyPressDetector.this.releaseEvent.getKeyCode()) && AdvancedKeyPressDetector.this.enabled) {
                    AdvancedKeyPressDetector advancedKeyPressDetector = AdvancedKeyPressDetector.this;
                    synchronized (advancedKeyPressDetector) {
                        if (AdvancedKeyPressDetector.this.isFocusInMainWindow()) {
                            for (KeyPressReleaseListener q : AdvancedKeyPressDetector.this.keyListeners) {
                                q.doKeyReleased(AdvancedKeyPressDetector.this.releaseEvent);
                            }
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        this.timer.stop();
        this.set.clear();
        AdvancedKeyPressDetector advancedKeyPressDetector = this;
        synchronized (advancedKeyPressDetector) {
            if (!this.keyListeners.isEmpty()) {
                Main.warn(I18n.tr("Some of the key listeners forgot to remove themselves: {0}", new Object[0]), this.keyListeners.toString());
            }
            if (!this.modifierListeners.isEmpty()) {
                Main.warn(I18n.tr("Some of the key modifier listeners forgot to remove themselves: {0}", new Object[0]), this.modifierListeners.toString());
            }
        }
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException ex) {
            Main.warn(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            if (this.timer.isRunning()) {
                this.timer.stop();
            } else if (this.set.add(e.getKeyCode()) && this.enabled) {
                AdvancedKeyPressDetector advancedKeyPressDetector = this;
                synchronized (advancedKeyPressDetector) {
                    if (this.isFocusInMainWindow()) {
                        for (KeyPressReleaseListener q : this.keyListeners) {
                            q.doKeyPressed(e);
                        }
                    }
                }
            }
        } else if (e.getID() == 402) {
            if (this.timer.isRunning()) {
                this.timer.stop();
                if (this.set.remove(e.getKeyCode()) && this.enabled) {
                    AdvancedKeyPressDetector advancedKeyPressDetector = this;
                    synchronized (advancedKeyPressDetector) {
                        if (this.isFocusInMainWindow()) {
                            for (KeyPressReleaseListener q : this.keyListeners) {
                                q.doKeyReleased(e);
                            }
                        }
                    }
                }
            } else {
                this.releaseEvent = e;
                this.timer.restart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventDispatched(AWTEvent e) {
        if (!(e instanceof KeyEvent)) {
            return;
        }
        KeyEvent ke = (KeyEvent)e;
        int modif = ke.getModifiers();
        if (this.previousModifiers != modif) {
            this.previousModifiers = modif;
            AdvancedKeyPressDetector advancedKeyPressDetector = this;
            synchronized (advancedKeyPressDetector) {
                for (ModifierListener m : this.modifierListeners) {
                    m.modifiersChanged(modif);
                }
            }
        }
        this.processKeyEvent(ke);
    }

    public boolean isKeyPressed(int keyCode) {
        return this.set.contains(keyCode);
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private boolean isFocusInMainWindow() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focused != null && SwingUtilities.getWindowAncestor(focused) instanceof JFrame;
    }
}

