/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.Adjustable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class AdjustmentSynchronizer
implements AdjustmentListener {
    private final List<Adjustable> synchronizedAdjustables = new ArrayList<Adjustable>();
    private final Map<Adjustable, Boolean> enabledMap = new HashMap<Adjustable, Boolean>();
    private final Observable observable = new Observable();

    public void participateInSynchronizedScrolling(Adjustable adjustable) {
        if (adjustable == null) {
            return;
        }
        if (this.synchronizedAdjustables.contains(adjustable)) {
            return;
        }
        this.synchronizedAdjustables.add(adjustable);
        this.setParticipatingInSynchronizedScrolling(adjustable, true);
        adjustable.addAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.enabledMap.get(e.getAdjustable()).booleanValue()) {
            return;
        }
        for (Adjustable a : this.synchronizedAdjustables) {
            if (a == e.getAdjustable() || !this.isParticipatingInSynchronizedScrolling(a)) continue;
            a.setValue(e.getValue());
        }
    }

    protected void setParticipatingInSynchronizedScrolling(Adjustable adjustable, boolean isParticipating) {
        CheckParameterUtil.ensureParameterNotNull(adjustable, "adjustable");
        if (!this.synchronizedAdjustables.contains(adjustable)) {
            throw new IllegalStateException(I18n.tr("Adjustable {0} not registered yet. Cannot set participation in synchronized adjustment.", adjustable));
        }
        this.enabledMap.put(adjustable, isParticipating);
        this.observable.notifyObservers();
    }

    protected boolean isParticipatingInSynchronizedScrolling(Adjustable adjustable) throws IllegalStateException {
        if (!this.synchronizedAdjustables.contains(adjustable)) {
            throw new IllegalStateException(I18n.tr("Adjustable {0} not registered yet.", adjustable));
        }
        return this.enabledMap.get(adjustable);
    }

    public void adapt(final JCheckBox view, final Adjustable adjustable) {
        CheckParameterUtil.ensureParameterNotNull(adjustable, "adjustable");
        CheckParameterUtil.ensureParameterNotNull(view, "view");
        if (!this.synchronizedAdjustables.contains(adjustable)) {
            this.participateInSynchronizedScrolling(adjustable);
        }
        view.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                switch (e.getStateChange()) {
                    case 1: {
                        if (AdjustmentSynchronizer.this.isParticipatingInSynchronizedScrolling(adjustable)) break;
                        AdjustmentSynchronizer.this.setParticipatingInSynchronizedScrolling(adjustable, true);
                        break;
                    }
                    case 2: {
                        if (!AdjustmentSynchronizer.this.isParticipatingInSynchronizedScrolling(adjustable)) break;
                        AdjustmentSynchronizer.this.setParticipatingInSynchronizedScrolling(adjustable, false);
                    }
                }
            }
        });
        this.observable.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                boolean sync = AdjustmentSynchronizer.this.isParticipatingInSynchronizedScrolling(adjustable);
                if (view.isSelected() != sync) {
                    view.setSelected(sync);
                }
            }
        });
        this.setParticipatingInSynchronizedScrolling(adjustable, true);
        view.setSelected(true);
    }
}

