/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItems;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPriority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class AutoCompletionManager
implements DataSetListener {
    protected boolean dirty;
    protected DataSet ds;
    protected MultiMap<String, String> tagCache;
    protected static final MultiMap<String, String> PRESET_TAG_CACHE = new MultiMap();
    protected static final Set<UserInputTag> USER_INPUT_TAG_CACHE = new LinkedHashSet<UserInputTag>();
    protected Set<String> roleCache;
    protected static final Set<String> PRESET_ROLE_CACHE = new HashSet<String>();

    public AutoCompletionManager(DataSet ds) {
        this.ds = ds;
        this.dirty = true;
    }

    protected MultiMap<String, String> getTagCache() {
        if (this.dirty) {
            this.rebuild();
            this.dirty = false;
        }
        return this.tagCache;
    }

    protected Set<String> getRoleCache() {
        if (this.dirty) {
            this.rebuild();
            this.dirty = false;
        }
        return this.roleCache;
    }

    protected void rebuild() {
        this.tagCache = new MultiMap();
        this.roleCache = new HashSet<String>();
        this.cachePrimitives(this.ds.allNonDeletedCompletePrimitives());
    }

    protected void cachePrimitives(Collection<? extends OsmPrimitive> primitives) {
        for (OsmPrimitive osmPrimitive : primitives) {
            this.cachePrimitiveTags(osmPrimitive);
            if (!(osmPrimitive instanceof Relation)) continue;
            this.cacheRelationMemberRoles((Relation)osmPrimitive);
        }
    }

    protected void cachePrimitiveTags(OsmPrimitive primitive) {
        for (String key : primitive.keySet()) {
            String value = primitive.get(key);
            this.tagCache.put(key, value);
        }
    }

    protected void cacheRelationMemberRoles(Relation relation) {
        for (RelationMember m : relation.getMembers()) {
            if (!m.hasRole()) continue;
            this.roleCache.add(m.getRole());
        }
    }

    public static void cachePresets(Collection<TaggingPreset> presets) {
        for (TaggingPreset p : presets) {
            for (TaggingPresetItem item : p.data) {
                if (item instanceof TaggingPresetItems.KeyedItem) {
                    TaggingPresetItems.KeyedItem ki = (TaggingPresetItems.KeyedItem)item;
                    if (ki.key == null || ki.getValues() == null) continue;
                    try {
                        PRESET_TAG_CACHE.putAll(ki.key, ki.getValues());
                    }
                    catch (NullPointerException e) {
                        Main.error(p + ": Unable to cache " + ki);
                    }
                    continue;
                }
                if (!(item instanceof TaggingPresetItems.Roles)) continue;
                TaggingPresetItems.Roles r = (TaggingPresetItems.Roles)item;
                for (TaggingPresetItems.Role i : r.roles) {
                    if (i.key == null) continue;
                    PRESET_ROLE_CACHE.add(i.key);
                }
            }
        }
    }

    public static void rememberUserInput(String key, String value, boolean defaultKey) {
        UserInputTag tag = new UserInputTag(key, value, defaultKey);
        USER_INPUT_TAG_CACHE.remove(tag);
        USER_INPUT_TAG_CACHE.add(tag);
    }

    protected List<String> getDataKeys() {
        return new ArrayList<String>(this.getTagCache().keySet());
    }

    protected List<String> getPresetKeys() {
        return new ArrayList<String>(PRESET_TAG_CACHE.keySet());
    }

    protected Collection<String> getUserInputKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (UserInputTag tag : USER_INPUT_TAG_CACHE) {
            if (tag.defaultKey) continue;
            keys.add(tag.key);
        }
        Collections.reverse(keys);
        return new LinkedHashSet<String>(keys);
    }

    protected List<String> getDataValues(String key) {
        return new ArrayList<String>(this.getTagCache().getValues(key));
    }

    protected static List<String> getPresetValues(String key) {
        return new ArrayList<String>(PRESET_TAG_CACHE.getValues(key));
    }

    protected static Collection<String> getUserInputValues(String key) {
        ArrayList<String> values = new ArrayList<String>();
        for (UserInputTag tag : USER_INPUT_TAG_CACHE) {
            if (!key.equals(tag.key)) continue;
            values.add(tag.value);
        }
        Collections.reverse(values);
        return new LinkedHashSet<String>(values);
    }

    public List<String> getMemberRoles() {
        return new ArrayList<String>(this.getRoleCache());
    }

    public void populateWithMemberRoles(AutoCompletionList list) {
        list.add(PRESET_ROLE_CACHE, AutoCompletionItemPriority.IS_IN_STANDARD);
        list.add(this.getRoleCache(), AutoCompletionItemPriority.IS_IN_DATASET);
    }

    public void populateWithMemberRoles(AutoCompletionList list, Relation r) {
        Collection<TaggingPreset> presets;
        CheckParameterUtil.ensureParameterNotNull(list, "list");
        Collection<TaggingPreset> collection = presets = r != null ? TaggingPreset.getMatchingPresets(null, r.getKeys(), false) : null;
        if (r != null && presets != null && !presets.isEmpty()) {
            for (TaggingPreset tp : presets) {
                if (tp.roles == null) continue;
                list.add(Utils.transform(tp.roles.roles, new Utils.Function<TaggingPresetItems.Role, String>(){

                    @Override
                    public String apply(TaggingPresetItems.Role x) {
                        return x.key;
                    }
                }), AutoCompletionItemPriority.IS_IN_STANDARD);
            }
            list.add(r.getMemberRoles(), AutoCompletionItemPriority.IS_IN_DATASET);
        } else {
            this.populateWithMemberRoles(list);
        }
    }

    public void populateWithKeys(AutoCompletionList list) {
        list.add(this.getPresetKeys(), AutoCompletionItemPriority.IS_IN_STANDARD);
        list.add(new AutoCompletionListItem("source", AutoCompletionItemPriority.IS_IN_STANDARD));
        list.add(this.getDataKeys(), AutoCompletionItemPriority.IS_IN_DATASET);
        list.addUserInput(this.getUserInputKeys());
    }

    public void populateWithTagValues(AutoCompletionList list, String key) {
        this.populateWithTagValues(list, Arrays.asList(key));
    }

    public void populateWithTagValues(AutoCompletionList list, List<String> keys) {
        for (String key : keys) {
            list.add(AutoCompletionManager.getPresetValues(key), AutoCompletionItemPriority.IS_IN_STANDARD);
            list.add(this.getDataValues(key), AutoCompletionItemPriority.IS_IN_DATASET);
            list.addUserInput(AutoCompletionManager.getUserInputValues(key));
        }
    }

    public List<AutoCompletionListItem> getKeys() {
        AutoCompletionList list = new AutoCompletionList();
        this.populateWithKeys(list);
        return list.getList();
    }

    public List<AutoCompletionListItem> getValues(String key) {
        return this.getValues(Arrays.asList(key));
    }

    public List<AutoCompletionListItem> getValues(List<String> keys) {
        AutoCompletionList list = new AutoCompletionList();
        this.populateWithTagValues(list, keys);
        return list.getList();
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
        if (this.dirty) {
            return;
        }
        this.cachePrimitives(event.getPrimitives());
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        this.dirty = true;
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        if (this.dirty) {
            return;
        }
        Map<String, String> newKeys = event.getPrimitive().getKeys();
        Map<String, String> oldKeys = event.getOriginalKeys();
        if (!newKeys.keySet().containsAll(oldKeys.keySet())) {
            this.dirty = true;
        } else {
            for (Map.Entry<String, String> oldEntry : oldKeys.entrySet()) {
                if (oldEntry.getValue().equals(newKeys.get(oldEntry.getKey()))) continue;
                this.dirty = true;
                return;
            }
            this.cachePrimitives(Collections.singleton(event.getPrimitive()));
        }
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
        this.dirty = true;
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        this.dirty = true;
    }

    public static class UserInputTag {
        private final String key;
        private final String value;
        private final boolean defaultKey;

        public UserInputTag(String key, String value, boolean defaultKey) {
            this.key = key;
            this.value = value;
            this.defaultKey = defaultKey;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + Objects.hashCode(this.key);
            hash = 59 * hash + Objects.hashCode(this.value);
            hash = 59 * hash + (this.defaultKey ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            UserInputTag other = (UserInputTag)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value) && this.defaultKey == other.defaultKey;
        }
    }
}

