/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPriority;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class AutoCompletionListItem
implements Comparable<AutoCompletionListItem> {
    private AutoCompletionItemPriority priority;
    private String value;

    public AutoCompletionListItem(String value, AutoCompletionItemPriority priority) {
        this.value = value;
        this.priority = priority;
    }

    public AutoCompletionListItem(String value) {
        this.value = value;
        this.priority = AutoCompletionItemPriority.UNKNOWN;
    }

    public AutoCompletionListItem() {
        this.value = "";
        this.priority = AutoCompletionItemPriority.UNKNOWN;
    }

    public AutoCompletionItemPriority getPriority() {
        return this.priority;
    }

    public void setPriority(AutoCompletionItemPriority priority) {
        this.priority = priority;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        CheckParameterUtil.ensureParameterNotNull(value, "value");
        this.value = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<val='");
        sb.append(this.value);
        sb.append("',");
        sb.append(this.priority.toString());
        sb.append(">");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return obj.equals(this.value);
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoCompletionListItem other = (AutoCompletionListItem)obj;
        if (this.priority == null ? other.priority != null : !this.priority.equals(other.priority)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(AutoCompletionListItem other) {
        int ret = other.priority.compareTo(this.priority);
        if (ret != 0) {
            return ret;
        }
        return this.value.compareTo(other.value);
    }
}

