/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPriority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class AutoCompletionList
extends AbstractTableModel {
    private List<AutoCompletionListItem> list = new ArrayList<AutoCompletionListItem>();
    private ArrayList<AutoCompletionListItem> filtered = new ArrayList();
    private String filter = null;
    private Map<String, AutoCompletionListItem> valutToItemMap = new HashMap<String, AutoCompletionListItem>();

    public void applyFilter(String filter) {
        CheckParameterUtil.ensureParameterNotNull(filter, "filter");
        this.filter = filter;
        this.filter();
    }

    public void clearFilter() {
        this.filter = null;
        this.filter();
    }

    public String getFilter() {
        return this.filter;
    }

    public void add(AutoCompletionListItem item) {
        if (item == null) {
            return;
        }
        this.appendOrUpdatePriority(item);
        this.sort();
        this.filter();
    }

    public void add(AutoCompletionList other) {
        CheckParameterUtil.ensureParameterNotNull(other, "other");
        for (AutoCompletionListItem item : other.list) {
            this.appendOrUpdatePriority(item);
        }
        this.sort();
        this.filter();
    }

    public void add(List<AutoCompletionListItem> other) {
        CheckParameterUtil.ensureParameterNotNull(other, "other");
        for (AutoCompletionListItem toadd : other) {
            this.appendOrUpdatePriority(toadd);
        }
        this.sort();
        this.filter();
    }

    public void add(Collection<String> values, AutoCompletionItemPriority priority) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            if (value == null) continue;
            AutoCompletionListItem item = new AutoCompletionListItem(value, priority);
            this.appendOrUpdatePriority(item);
        }
        this.sort();
        this.filter();
    }

    public void addUserInput(Collection<String> values) {
        if (values == null) {
            return;
        }
        int i = 0;
        for (String value : values) {
            if (value == null) continue;
            AutoCompletionListItem item = new AutoCompletionListItem(value, new AutoCompletionItemPriority(false, false, false, i));
            this.appendOrUpdatePriority(item);
            ++i;
        }
        this.sort();
        this.filter();
    }

    protected void appendOrUpdatePriority(AutoCompletionListItem toAdd) {
        AutoCompletionListItem item = this.valutToItemMap.get(toAdd.getValue());
        if (item == null) {
            this.list.add(toAdd);
            this.valutToItemMap.put(toAdd.getValue(), toAdd);
        } else {
            item.setPriority(item.getPriority().mergeWith(toAdd.getPriority()));
        }
    }

    public boolean contains(AutoCompletionListItem item) {
        if (item == null) {
            return false;
        }
        return this.list.contains(item);
    }

    public boolean contains(String value) {
        if (value == null) {
            return false;
        }
        for (AutoCompletionListItem item : this.list) {
            if (!item.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public void remove(String key) {
        if (key == null) {
            return;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            AutoCompletionListItem item = this.list.get(i);
            if (!item.getValue().equals(key)) continue;
            this.list.remove(i);
            return;
        }
    }

    protected void sort() {
        Collections.sort(this.list);
    }

    protected void filter() {
        this.filtered.clear();
        if (this.filter == null) {
            this.filtered.ensureCapacity(this.list.size());
            for (AutoCompletionListItem item : this.list) {
                this.filtered.add(item);
            }
            return;
        }
        for (AutoCompletionListItem item : this.list) {
            if (!item.getValue().startsWith(this.filter)) continue;
            this.filtered.add(item);
        }
        this.fireTableDataChanged();
    }

    public int getFilteredSize() {
        return this.filtered.size();
    }

    public AutoCompletionListItem getFilteredItem(int idx) {
        if (idx < 0 || idx >= this.getFilteredSize()) {
            throw new IndexOutOfBoundsException("idx out of bounds. idx=" + idx);
        }
        return this.filtered.get(idx);
    }

    List<AutoCompletionListItem> getList() {
        return this.list;
    }

    public void clear() {
        this.valutToItemMap.clear();
        this.list.clear();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.list == null ? 0 : this.getFilteredSize();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.list == null ? null : this.getFilteredItem(rowIndex);
    }
}

