/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

public class AutoCompletionItemPriority
implements Comparable<AutoCompletionItemPriority> {
    public static final AutoCompletionItemPriority IS_IN_STANDARD_AND_IN_DATASET = new AutoCompletionItemPriority(true, true, false);
    public static final AutoCompletionItemPriority IS_IN_DATASET = new AutoCompletionItemPriority(true, false, false);
    public static final AutoCompletionItemPriority IS_IN_STANDARD = new AutoCompletionItemPriority(false, true, false);
    public static final AutoCompletionItemPriority IS_IN_SELECTION = new AutoCompletionItemPriority(false, false, true);
    public static final AutoCompletionItemPriority UNKNOWN = new AutoCompletionItemPriority(false, false, false);
    private final int userInput;
    private final boolean inDataSet;
    private final boolean inStandard;
    private final boolean selected;

    public AutoCompletionItemPriority(boolean inDataSet, boolean inStandard, boolean selected, Integer userInput) {
        this.inDataSet = inDataSet;
        this.inStandard = inStandard;
        this.selected = selected;
        this.userInput = userInput == null ? Integer.MAX_VALUE : userInput;
    }

    public AutoCompletionItemPriority(boolean inDataSet, boolean inStandard, boolean selected) {
        this(inDataSet, inStandard, selected, Integer.MAX_VALUE);
    }

    public boolean isInDataSet() {
        return this.inDataSet;
    }

    public boolean isInStandard() {
        return this.inStandard;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Integer getUserInput() {
        return this.userInput == Integer.MAX_VALUE ? null : Integer.valueOf(this.userInput);
    }

    @Override
    public int compareTo(AutoCompletionItemPriority other) {
        int ui = -Integer.compare(this.userInput, other.userInput);
        if (ui != 0) {
            return ui;
        }
        int sel = Boolean.valueOf(this.selected).compareTo(other.selected);
        if (sel != 0) {
            return sel;
        }
        int ds = Boolean.valueOf(this.inDataSet).compareTo(other.inDataSet);
        if (ds != 0) {
            return ds;
        }
        int std = Boolean.valueOf(this.inStandard).compareTo(other.inStandard);
        if (std != 0) {
            return std;
        }
        return 0;
    }

    public AutoCompletionItemPriority mergeWith(AutoCompletionItemPriority other) {
        return new AutoCompletionItemPriority(this.inDataSet || other.inDataSet, this.inStandard || other.inStandard, this.selected || other.selected, Math.min(this.userInput, other.userInput));
    }

    public String toString() {
        return String.format("<Priority; userInput: %s, inDataSet: %b, inStandard: %b, selected: %b>", this.userInput == Integer.MAX_VALUE ? "no" : Integer.toString(this.userInput), this.inDataSet, this.inStandard, this.selected);
    }
}

