/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.im.InputContext;
import java.util.Collection;
import java.util.Locale;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPriority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;

public class AutoCompletingComboBox
extends JosmComboBox<AutoCompletionListItem> {
    private boolean autocompleteEnabled = true;
    private int maxTextLength = -1;
    private boolean useFixedLocale;
    private static InputContext privateInputContext = InputContext.getInstance();

    public AutoCompletingComboBox() {
        this("Foo");
    }

    public AutoCompletingComboBox(String prototype) {
        super(new AutoCompletionListItem(prototype));
        this.setRenderer(new AutoCompleteListCellRenderer());
        final JTextComponent editorComponent = (JTextComponent)this.getEditor().getEditorComponent();
        editorComponent.setDocument(new AutoCompletingComboBoxDocument(this));
        editorComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Main.map != null) {
                    Main.map.keyDetector.setEnabled(true);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                Clipboard sysSel;
                if (Main.map != null) {
                    Main.map.keyDetector.setEnabled(false);
                }
                if ((sysSel = Toolkit.getDefaultToolkit().getSystemSelection()) != null) {
                    Transferable old = sysSel.getContents(null);
                    editorComponent.selectAll();
                    sysSel.setContents(old, null);
                } else {
                    editorComponent.selectAll();
                }
            }
        });
    }

    public void setMaxTextLength(int length) {
        this.maxTextLength = length;
    }

    @Override
    public void configureEditor(ComboBoxEditor cbEditor, Object item) {
        if (item == null) {
            cbEditor.setItem(null);
        } else if (item instanceof String) {
            cbEditor.setItem(item);
        } else if (item instanceof AutoCompletionListItem) {
            cbEditor.setItem(((AutoCompletionListItem)item).getValue());
        } else {
            throw new IllegalArgumentException("Unsupported item: " + item);
        }
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            super.setSelectedItem(null);
        } else if (item instanceof AutoCompletionListItem) {
            super.setSelectedItem(item);
        } else if (item instanceof String) {
            String s = (String)item;
            for (int i = 0; i < this.getModel().getSize(); ++i) {
                AutoCompletionListItem acItem = (AutoCompletionListItem)this.getModel().getElementAt(i);
                if (!s.equals(acItem.getValue())) continue;
                super.setSelectedItem(acItem);
                return;
            }
            super.setSelectedItem(new AutoCompletionListItem(s, AutoCompletionItemPriority.UNKNOWN));
        } else {
            throw new IllegalArgumentException("Unsupported item: " + item);
        }
    }

    public void setPossibleItems(Collection<String> elems) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        Object oldValue = this.getEditor().getItem();
        model.removeAllElements();
        for (String elem : elems) {
            model.addElement(new AutoCompletionListItem(elem, AutoCompletionItemPriority.UNKNOWN));
        }
        this.autocompleteEnabled = false;
        this.getEditor().setItem(oldValue);
        this.autocompleteEnabled = true;
    }

    public void setPossibleACItems(Collection<AutoCompletionListItem> elems) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        Object oldValue = this.getSelectedItem();
        Object editorOldValue = this.getEditor().getItem();
        model.removeAllElements();
        for (AutoCompletionListItem elem : elems) {
            model.addElement(elem);
        }
        this.setSelectedItem(oldValue);
        this.getEditor().setItem(editorOldValue);
    }

    public final boolean isAutocompleteEnabled() {
        return this.autocompleteEnabled;
    }

    protected void setAutocompleteEnabled(boolean autocompleteEnabled) {
        this.autocompleteEnabled = autocompleteEnabled;
    }

    public void setFixedLocale(boolean f) {
        this.useFixedLocale = f;
        if (this.useFixedLocale) {
            privateInputContext.selectInputMethod(new Locale("en", "US"));
        }
    }

    @Override
    public InputContext getInputContext() {
        if (this.useFixedLocale) {
            return privateInputContext;
        }
        return super.getInputContext();
    }

    public static class AutoCompleteListCellRenderer
    extends JLabel
    implements ListCellRenderer<AutoCompletionListItem> {
        public AutoCompleteListCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AutoCompletionListItem> list, AutoCompletionListItem item, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(item.getValue());
            return this;
        }
    }

    class AutoCompletingComboBoxDocument
    extends PlainDocument {
        private JosmComboBox<AutoCompletionListItem> comboBox;
        private boolean selecting = false;

        public AutoCompletingComboBoxDocument(JosmComboBox<AutoCompletionListItem> comboBox) {
            this.comboBox = comboBox;
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.remove(offs, len);
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String newText;
            int start;
            if (this.selecting || offs == 0 && str.equals(this.getText(0, this.getLength()))) {
                return;
            }
            if (AutoCompletingComboBox.this.maxTextLength > -1 && str.length() + this.getLength() > AutoCompletingComboBox.this.maxTextLength) {
                return;
            }
            boolean initial = offs == 0 && this.getLength() == 0 && str.length() > 1;
            super.insertString(offs, str, a);
            if (this.selecting) {
                return;
            }
            if (!AutoCompletingComboBox.this.autocompleteEnabled) {
                return;
            }
            if (a != null && a.isDefined(StyleConstants.ComposedTextAttribute)) {
                return;
            }
            int size = this.getLength();
            int end = start = offs + str.length();
            String curText = this.getText(0, size);
            Object item = null;
            if (Main.pref.getBoolean("autocomplete.dont_complete_numbers", true)) {
                try {
                    Long.parseLong(str);
                    if (curText.length() != 0) {
                        Long.parseLong(curText);
                    }
                    item = this.lookupItem(curText, true);
                }
                catch (NumberFormatException e) {
                    item = this.lookupItem(curText, false);
                }
            } else {
                item = this.lookupItem(curText, false);
            }
            this.setSelectedItem(item);
            if (initial) {
                start = 0;
            }
            if (item != null && !(newText = ((AutoCompletionListItem)item).getValue()).equals(curText)) {
                this.selecting = true;
                super.remove(0, size);
                super.insertString(0, newText, a);
                this.selecting = false;
                start = size;
                end = this.getLength();
            }
            JTextComponent editorComponent = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
            Clipboard sysSel = Toolkit.getDefaultToolkit().getSystemSelection();
            if (sysSel != null) {
                Transferable old = sysSel.getContents(null);
                editorComponent.select(start, end);
                sysSel.setContents(old, null);
            } else {
                editorComponent.select(start, end);
            }
        }

        private void setSelectedItem(Object item) {
            this.selecting = true;
            this.comboBox.setSelectedItem(item);
            this.selecting = false;
        }

        private Object lookupItem(String pattern, boolean match) {
            ComboBoxModel model = this.comboBox.getModel();
            AutoCompletionListItem bestItem = null;
            int n = model.getSize();
            for (int i = 0; i < n; ++i) {
                AutoCompletionListItem currentItem = (AutoCompletionListItem)model.getElementAt(i);
                if (currentItem.getValue().equals(pattern)) {
                    return currentItem;
                }
                if (match || !currentItem.getValue().startsWith(pattern) || bestItem != null && currentItem.getPriority().compareTo(bestItem.getPriority()) <= 0) continue;
                bestItem = currentItem;
            }
            return bestItem;
        }
    }
}

