/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetListener;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;

public final class TaggingPresets {
    private static final Collection<TaggingPreset> taggingPresets = new ArrayList<TaggingPreset>();
    private static final Collection<TaggingPresetListener> listeners = new ArrayList<TaggingPresetListener>();

    public static void readFromPreferences() {
        taggingPresets.clear();
        taggingPresets.addAll(TaggingPresetReader.readFromPreferences(false, false));
    }

    public static void initialize() {
        TaggingPresets.readFromPreferences();
        for (TaggingPreset tp : taggingPresets) {
            if (tp instanceof TaggingPresetSeparator) continue;
            Main.toolbar.register(tp);
        }
        if (taggingPresets.isEmpty()) {
            Main.main.menu.presetsMenu.setVisible(false);
        } else {
            AutoCompletionManager.cachePresets(taggingPresets);
            HashMap<TaggingPresetMenu, JMenu> submenus = new HashMap<TaggingPresetMenu, JMenu>();
            for (TaggingPreset p : taggingPresets) {
                JMenu m;
                JMenu jMenu = m = p.group != null ? (JMenu)submenus.get(p.group) : Main.main.menu.presetsMenu;
                if (p instanceof TaggingPresetSeparator) {
                    m.add(new JSeparator());
                    continue;
                }
                if (p instanceof TaggingPresetMenu) {
                    JMenu submenu = new JMenu(p);
                    submenu.setText(p.getLocaleName());
                    ((TaggingPresetMenu)p).menu = submenu;
                    submenus.put((TaggingPresetMenu)p, submenu);
                    m.add(submenu);
                    continue;
                }
                JMenuItem mi = new JMenuItem(p);
                mi.setText(p.getLocaleName());
                m.add(mi);
            }
        }
        if (Main.pref.getBoolean("taggingpreset.sortmenu")) {
            TaggingPresetMenu.sortMenu(Main.main.menu.presetsMenu);
        }
    }

    public static Collection<TaggingPreset> getTaggingPresets() {
        return new ArrayList<TaggingPreset>(taggingPresets);
    }

    public static void addTaggingPresets(Collection<TaggingPreset> presets) {
        if (presets != null && taggingPresets.addAll(presets)) {
            for (TaggingPresetListener listener : listeners) {
                listener.taggingPresetsModified();
            }
        }
    }

    public static void addListener(TaggingPresetListener listener) {
        if (listener != null) {
            listeners.add(listener);
        }
    }

    public static void removeListener(TaggingPresetListener listener) {
        if (listener != null) {
            listeners.remove(listener);
        }
    }
}

