/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItems;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.TaggingPresets;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class TaggingPresetSelector
extends JPanel
implements SelectionChangedListener {
    private static final BooleanProperty SEARCH_IN_TAGS = new BooleanProperty("taggingpreset.dialog.search-in-tags", true);
    private static final BooleanProperty ONLY_APPLICABLE = new BooleanProperty("taggingpreset.dialog.only-applicable-to-selection", true);
    private final JosmTextField edSearchText;
    private final JList<TaggingPreset> lsResult;
    private final JCheckBox ckOnlyApplicable;
    private final JCheckBox ckSearchInTags;
    private final EnumSet<TaggingPresetType> typesInSelection = EnumSet.noneOf(TaggingPresetType.class);
    private boolean typesInSelectionDirty = true;
    private final PresetClassifications classifications = new PresetClassifications();
    private final ResultListModel lsResultModel = new ResultListModel();
    private final List<ListSelectionListener> listSelectionListeners = new ArrayList<ListSelectionListener>();
    private ActionListener dblClickListener;
    private ActionListener clickListener;

    public TaggingPresetSelector(boolean displayOnlyApplicable, boolean displaySearchInTags) {
        super(new BorderLayout());
        this.classifications.loadPresets(TaggingPresets.getTaggingPresets());
        this.edSearchText = new JosmTextField();
        this.edSearchText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TaggingPresetSelector.this.filterPresets();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TaggingPresetSelector.this.filterPresets();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TaggingPresetSelector.this.filterPresets();
            }
        });
        this.edSearchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 40: {
                        TaggingPresetSelector.this.selectPreset(TaggingPresetSelector.this.lsResult.getSelectedIndex() + 1);
                        break;
                    }
                    case 38: {
                        TaggingPresetSelector.this.selectPreset(TaggingPresetSelector.this.lsResult.getSelectedIndex() - 1);
                        break;
                    }
                    case 34: {
                        TaggingPresetSelector.this.selectPreset(TaggingPresetSelector.this.lsResult.getSelectedIndex() + 10);
                        break;
                    }
                    case 33: {
                        TaggingPresetSelector.this.selectPreset(TaggingPresetSelector.this.lsResult.getSelectedIndex() - 10);
                        break;
                    }
                    case 36: {
                        TaggingPresetSelector.this.selectPreset(0);
                        break;
                    }
                    case 35: {
                        TaggingPresetSelector.this.selectPreset(TaggingPresetSelector.this.lsResultModel.getSize());
                    }
                }
            }
        });
        this.add((Component)this.edSearchText, "North");
        this.lsResult = new JList<TaggingPreset>(this.lsResultModel);
        this.lsResult.setCellRenderer(new ResultListCellRenderer());
        this.lsResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    if (TaggingPresetSelector.this.dblClickListener != null) {
                        TaggingPresetSelector.this.dblClickListener.actionPerformed(null);
                    }
                } else if (TaggingPresetSelector.this.clickListener != null) {
                    TaggingPresetSelector.this.clickListener.actionPerformed(null);
                }
            }
        });
        this.add((Component)new JScrollPane(this.lsResult), "Center");
        JPanel pnChecks = new JPanel();
        pnChecks.setLayout(new BoxLayout(pnChecks, 1));
        if (displayOnlyApplicable) {
            this.ckOnlyApplicable = new JCheckBox();
            this.ckOnlyApplicable.setText(I18n.tr("Show only applicable to selection", new Object[0]));
            pnChecks.add(this.ckOnlyApplicable);
            this.ckOnlyApplicable.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TaggingPresetSelector.this.filterPresets();
                }
            });
        } else {
            this.ckOnlyApplicable = null;
        }
        if (displaySearchInTags) {
            this.ckSearchInTags = new JCheckBox();
            this.ckSearchInTags.setText(I18n.tr("Search in tags", new Object[0]));
            this.ckSearchInTags.setSelected(SEARCH_IN_TAGS.get());
            this.ckSearchInTags.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TaggingPresetSelector.this.filterPresets();
                }
            });
            pnChecks.add(this.ckSearchInTags);
        } else {
            this.ckSearchInTags = null;
        }
        this.add((Component)pnChecks, "South");
        this.setPreferredSize(new Dimension(400, 300));
        this.filterPresets();
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AbstractAction(I18n.tr("Add toolbar button", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String res = TaggingPresetSelector.this.getSelectedPreset().getToolbarString();
                Main.toolbar.addCustomButton(res, -1, false);
            }
        });
        this.lsResult.addMouseListener(new PopupMenuLauncher(popupMenu));
    }

    private synchronized void selectPreset(int newIndex) {
        if (newIndex < 0) {
            newIndex = 0;
        }
        if (newIndex > this.lsResultModel.getSize() - 1) {
            newIndex = this.lsResultModel.getSize() - 1;
        }
        this.lsResult.setSelectedIndex(newIndex);
        this.lsResult.ensureIndexIsVisible(newIndex);
    }

    private synchronized void filterPresets() {
        String text = this.edSearchText.getText().toLowerCase();
        boolean onlyApplicable = this.ckOnlyApplicable != null && this.ckOnlyApplicable.isSelected();
        boolean inTags = this.ckSearchInTags != null && this.ckSearchInTags.isSelected();
        DataSet ds = Main.main.getCurrentDataSet();
        Collection<Object> selected = ds == null ? Collections.emptyList() : ds.getSelected();
        List<PresetClassification> result = this.classifications.getMatchingPresets(text, onlyApplicable, inTags, this.getTypesInSelection(), selected);
        TaggingPreset oldPreset = this.getSelectedPreset();
        this.lsResultModel.setPresets(result);
        TaggingPreset newPreset = this.getSelectedPreset();
        if (!Objects.equals(oldPreset, newPreset)) {
            int[] indices = this.lsResult.getSelectedIndices();
            for (ListSelectionListener listener : this.listSelectionListeners) {
                listener.valueChanged(new ListSelectionEvent(this.lsResult, this.lsResult.getSelectedIndex(), indices.length > 0 ? indices[indices.length - 1] : -1, false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnumSet<TaggingPresetType> getTypesInSelection() {
        if (this.typesInSelectionDirty) {
            EnumSet<TaggingPresetType> enumSet = this.typesInSelection;
            synchronized (enumSet) {
                this.typesInSelectionDirty = false;
                this.typesInSelection.clear();
                if (Main.main == null || Main.main.getCurrentDataSet() == null) {
                    return this.typesInSelection;
                }
                for (OsmPrimitive primitive : Main.main.getCurrentDataSet().getSelected()) {
                    this.typesInSelection.add(TaggingPresetType.forPrimitive(primitive));
                }
            }
        }
        return this.typesInSelection;
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.typesInSelectionDirty = true;
    }

    public synchronized void init() {
        if (this.ckOnlyApplicable != null) {
            this.ckOnlyApplicable.setEnabled(!this.getTypesInSelection().isEmpty());
            this.ckOnlyApplicable.setSelected(!this.getTypesInSelection().isEmpty() && ONLY_APPLICABLE.get() != false);
        }
        this.listSelectionListeners.clear();
        this.edSearchText.setText("");
        this.filterPresets();
    }

    public void init(Collection<TaggingPreset> presets) {
        this.classifications.clear();
        this.classifications.loadPresets(presets);
        this.init();
    }

    public synchronized void clearSelection() {
        this.lsResult.getSelectionModel().clearSelection();
    }

    public void savePreferences() {
        if (this.ckSearchInTags != null) {
            SEARCH_IN_TAGS.put(this.ckSearchInTags.isSelected());
        }
        if (this.ckOnlyApplicable != null && this.ckOnlyApplicable.isEnabled()) {
            ONLY_APPLICABLE.put(this.ckOnlyApplicable.isSelected());
        }
    }

    public synchronized TaggingPreset getSelectedPreset() {
        if (this.lsResultModel.isEmpty()) {
            return null;
        }
        int idx = this.lsResult.getSelectedIndex();
        if (idx < 0 || idx >= this.lsResultModel.getSize()) {
            idx = 0;
        }
        TaggingPreset preset = this.lsResultModel.getElementAt(idx);
        for (PresetClassification pc : this.classifications) {
            if (pc.preset == preset) {
                pc.favoriteIndex = 300;
                continue;
            }
            if (pc.favoriteIndex <= 0) continue;
            --pc.favoriteIndex;
        }
        return preset;
    }

    public synchronized void setSelectedPreset(TaggingPreset p) {
        this.lsResult.setSelectedValue(p, true);
    }

    public synchronized int getItemCount() {
        return this.lsResultModel.getSize();
    }

    public void setDblClickListener(ActionListener dblClickListener) {
        this.dblClickListener = dblClickListener;
    }

    public void setClickListener(ActionListener clickListener) {
        this.clickListener = clickListener;
    }

    public synchronized void addSelectionListener(ListSelectionListener selectListener) {
        this.lsResult.getSelectionModel().addListSelectionListener(selectListener);
        this.listSelectionListeners.add(selectListener);
    }

    public synchronized void removeSelectionListener(ListSelectionListener selectListener) {
        this.listSelectionListeners.remove(selectListener);
        this.lsResult.getSelectionModel().removeListSelectionListener(selectListener);
    }

    static class PresetClassifications
    implements Iterable<PresetClassification> {
        private final List<PresetClassification> classifications = new ArrayList<PresetClassification>();

        PresetClassifications() {
        }

        public List<PresetClassification> getMatchingPresets(String searchText, boolean onlyApplicable, boolean inTags, EnumSet<TaggingPresetType> presetTypes, Collection<? extends OsmPrimitive> selectedPrimitives) {
            String[] nameWords;
            String[] groupWords;
            if (searchText.contains("/")) {
                groupWords = searchText.substring(0, searchText.lastIndexOf(47)).split("[\\s/]");
                nameWords = searchText.substring(searchText.indexOf(47) + 1).split("\\s");
            } else {
                groupWords = null;
                nameWords = searchText.split("\\s");
            }
            return this.getMatchingPresets(groupWords, nameWords, onlyApplicable, inTags, presetTypes, selectedPrimitives);
        }

        public List<PresetClassification> getMatchingPresets(String[] groupWords, String[] nameWords, boolean onlyApplicable, boolean inTags, EnumSet<TaggingPresetType> presetTypes, final Collection<? extends OsmPrimitive> selectedPrimitives) {
            ArrayList<PresetClassification> result = new ArrayList<PresetClassification>();
            for (PresetClassification presetClassification : this.classifications) {
                TaggingPreset preset = presetClassification.preset;
                presetClassification.classification = 0;
                if (onlyApplicable) {
                    boolean suitable = preset.typeMatches(presetTypes);
                    if (!suitable && preset.types.contains((Object)TaggingPresetType.RELATION) && preset.roles != null && !preset.roles.roles.isEmpty()) {
                        Predicate<TaggingPresetItems.Role> memberExpressionMatchesOnePrimitive = new Predicate<TaggingPresetItems.Role>(){

                            @Override
                            public boolean evaluate(TaggingPresetItems.Role object) {
                                return object.memberExpression != null && Utils.exists(selectedPrimitives, object.memberExpression);
                            }
                        };
                        suitable = Utils.exists(preset.roles.roles, memberExpressionMatchesOnePrimitive);
                    }
                    if (!suitable) continue;
                }
                if (groupWords != null && presetClassification.isMatchingGroup(groupWords) == 0) continue;
                int matchName = presetClassification.isMatchingName(nameWords);
                if (matchName == 0) {
                    int tagsMatch;
                    int groupMatch;
                    if (groupWords == null && (groupMatch = presetClassification.isMatchingGroup(nameWords)) > 0) {
                        presetClassification.classification = 200 + groupMatch;
                    }
                    if (presetClassification.classification == 0 && inTags && (tagsMatch = presetClassification.isMatchingTags(nameWords)) > 0) {
                        presetClassification.classification = 100 + tagsMatch;
                    }
                } else {
                    presetClassification.classification = 300 + matchName;
                }
                if (presetClassification.classification <= 0) continue;
                presetClassification.classification += presetClassification.favoriteIndex;
                result.add(presetClassification);
            }
            Collections.sort(result);
            return result;
        }

        public void clear() {
            this.classifications.clear();
        }

        public void loadPresets(Collection<TaggingPreset> presets) {
            for (TaggingPreset preset : presets) {
                if (preset instanceof TaggingPresetSeparator || preset instanceof TaggingPresetMenu) continue;
                this.classifications.add(new PresetClassification(preset));
            }
        }

        @Override
        public Iterator<PresetClassification> iterator() {
            return this.classifications.iterator();
        }
    }

    static class PresetClassification
    implements Comparable<PresetClassification> {
        public final TaggingPreset preset;
        public int classification;
        public int favoriteIndex;
        private final Collection<String> groups = new HashSet<String>();
        private final Collection<String> names = new HashSet<String>();
        private final Collection<String> tags = new HashSet<String>();

        PresetClassification(TaggingPreset preset) {
            this.preset = preset;
            TaggingPresetMenu group = preset.group;
            while (group != null) {
                Collections.addAll(this.groups, group.getLocaleName().toLowerCase().split("\\s"));
                group = group.group;
            }
            Collections.addAll(this.names, preset.getLocaleName().toLowerCase().split("\\s"));
            for (TaggingPresetItem item : preset.data) {
                if (item instanceof TaggingPresetItems.KeyedItem) {
                    this.tags.add(((TaggingPresetItems.KeyedItem)item).key);
                    if (item instanceof TaggingPresetItems.ComboMultiSelect) {
                        TaggingPresetItems.ComboMultiSelect cms = (TaggingPresetItems.ComboMultiSelect)item;
                        if (Boolean.parseBoolean(cms.values_searchable)) {
                            this.tags.addAll(cms.getDisplayValues());
                        }
                    }
                    if (!(item instanceof TaggingPresetItems.Key) || ((TaggingPresetItems.Key)item).value == null) continue;
                    this.tags.add(((TaggingPresetItems.Key)item).value);
                    continue;
                }
                if (!(item instanceof TaggingPresetItems.Roles)) continue;
                for (TaggingPresetItems.Role role : ((TaggingPresetItems.Roles)item).roles) {
                    this.tags.add(role.key);
                }
            }
        }

        private int isMatching(Collection<String> values, String[] searchString) {
            int sum = 0;
            for (String word : searchString) {
                boolean found = false;
                boolean foundFirst = false;
                for (String value : values) {
                    int index = value.toLowerCase().indexOf(word);
                    if (index == 0) {
                        foundFirst = true;
                        break;
                    }
                    if (index <= 0) continue;
                    found = true;
                }
                if (foundFirst) {
                    sum += 2;
                    continue;
                }
                if (found) {
                    ++sum;
                    continue;
                }
                return 0;
            }
            return sum;
        }

        int isMatchingGroup(String[] words) {
            return this.isMatching(this.groups, words);
        }

        int isMatchingName(String[] words) {
            return this.isMatching(this.names, words);
        }

        int isMatchingTags(String[] words) {
            return this.isMatching(this.tags, words);
        }

        @Override
        public int compareTo(PresetClassification o) {
            int result = o.classification - this.classification;
            if (result == 0) {
                return this.preset.getName().compareTo(o.preset.getName());
            }
            return result;
        }

        public String toString() {
            return this.classification + " " + this.preset.toString();
        }
    }

    private static class ResultListModel
    extends AbstractListModel<TaggingPreset> {
        private List<PresetClassification> presets = new ArrayList<PresetClassification>();

        private ResultListModel() {
        }

        public synchronized void setPresets(List<PresetClassification> presets) {
            this.presets = presets;
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }

        @Override
        public synchronized TaggingPreset getElementAt(int index) {
            return this.presets.get((int)index).preset;
        }

        @Override
        public synchronized int getSize() {
            return this.presets.size();
        }

        public synchronized boolean isEmpty() {
            return this.presets.isEmpty();
        }
    }

    private static class ResultListCellRenderer
    implements ListCellRenderer<TaggingPreset> {
        final DefaultListCellRenderer def = new DefaultListCellRenderer();

        private ResultListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TaggingPreset> list, TaggingPreset tp, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel result = (JLabel)this.def.getListCellRendererComponent(list, tp, index, isSelected, cellHasFocus);
            result.setText(tp.getName());
            result.setIcon((Icon)tp.getValue("SmallIcon"));
            return result;
        }
    }
}

